/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.ess3.nms.refl.ReflUtil;
import net.ess3.provider.LoggerProvider;
import net.ess3.provider.providers.BaseLoggerProvider;
import net.ess3.provider.providers.PaperLoggerProvider;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class EssentialsLogger {
    private static final Map<String, LoggerProvider> loggerProviders = new HashMap<String, LoggerProvider>();
    private static final MethodHandle loggerFieldHandle;

    private EssentialsLogger() {
    }

    public static LoggerProvider getLoggerProvider(Plugin plugin) {
        LoggerProvider provider;
        if (loggerProviders.containsKey(plugin.getName())) {
            return loggerProviders.get(plugin.getName());
        }
        Logger parentLogger = Logger.getLogger(plugin.getName());
        if (ReflUtil.getClassCached("io.papermc.paper.adventure.providers.ComponentLoggerProviderImpl") != null) {
            provider = new PaperLoggerProvider(plugin);
            provider.setParent(parentLogger);
        } else {
            provider = new BaseLoggerProvider(plugin, parentLogger);
            provider.setParent(parentLogger);
        }
        loggerProviders.put(plugin.getName(), provider);
        return provider;
    }

    public static void updatePluginLogger(Plugin plugin) {
        LoggerProvider provider = EssentialsLogger.getLoggerProvider(plugin);
        try {
            loggerFieldHandle.invoke(plugin, provider);
        }
        catch (Throwable e) {
            provider.log(Level.SEVERE, "Failed to update " + plugin.getName() + " logger", e);
        }
    }

    public static LoggerProvider getLoggerProvider(String pluginName) {
        if (loggerProviders.containsKey(pluginName)) {
            return loggerProviders.get(pluginName);
        }
        Plugin plugin = Bukkit.getPluginManager().getPlugin(pluginName);
        if (plugin == null) {
            throw new IllegalArgumentException("Plugin not found: " + pluginName);
        }
        return EssentialsLogger.getLoggerProvider(plugin);
    }

    static {
        try {
            Field loggerField = ReflUtil.getFieldCached(JavaPlugin.class, "logger");
            loggerFieldHandle = MethodHandles.lookup().unreflectSetter(loggerField);
        }
        catch (Throwable t) {
            throw new RuntimeException("Failed to get logger field handle", t);
        }
    }
}

