/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials;

import com.earth2me.essentials.utils.EnumUtil;
import com.earth2me.essentials.utils.RegistryUtil;
import com.earth2me.essentials.utils.VersionUtil;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import net.ess3.nms.refl.ReflUtil;
import org.bukkit.Material;
import org.bukkit.TreeSpecies;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Axolotl;
import org.bukkit.entity.Boat;
import org.bukkit.entity.Camel;
import org.bukkit.entity.Chicken;
import org.bukkit.entity.Cow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Fox;
import org.bukkit.entity.Frog;
import org.bukkit.entity.Llama;
import org.bukkit.entity.MushroomCow;
import org.bukkit.entity.Ocelot;
import org.bukkit.entity.Panda;
import org.bukkit.entity.Parrot;
import org.bukkit.entity.Pig;
import org.bukkit.entity.Player;
import org.bukkit.entity.Salmon;
import org.bukkit.entity.TropicalFish;
import org.bukkit.entity.Villager;
import org.bukkit.entity.Wolf;
import org.bukkit.inventory.ItemStack;

public final class MobCompat {
    public static final Class<?> RAIDER = ReflUtil.getClassCached("org.bukkit.entity.Raider");
    private static final Class<?> COW = ReflUtil.getClassCached("org.bukkit.entity.Cow");
    private static final Class<?> COW_VARIANT = ReflUtil.getClassCached("org.bukkit.entity.Cow$Variant");
    private static final MethodHandle COW_VARIANT_HANDLE;
    public static final EntityType LLAMA;
    public static final EntityType PARROT;
    public static final EntityType TROPICAL_FISH;
    public static final EntityType PANDA;
    public static final EntityType TRADER_LLAMA;
    public static final EntityType SHULKER;
    public static final EntityType STRAY;
    public static final EntityType FOX;
    public static final EntityType PHANTOM;
    public static final EntityType AXOLOTL;
    public static final EntityType GOAT;
    public static final EntityType FROG;
    public static final EntityType CAMEL;
    public static final EntityType SALMON;
    public static final EntityType CAT;
    public static final EntityType ZOMBIFIED_PIGLIN;
    public static final EntityType MOOSHROOM;
    public static final EntityType SNOW_GOLEM;
    public static final EntityType CHEST_MINECART;
    public static final EntityType FURNACE_MINECART;
    public static final EntityType TNT_MINECART;
    public static final EntityType HOPPER_MINECART;
    public static final EntityType SPAWNER_MINECART;
    public static final EntityType END_CRYSTAL;
    public static final EntityType FIREWORK_ROCKET;
    public static final EntityType OAK_BOAT;

    private MobCompat() {
    }

    public static void setCatType(Entity entity, CatType type) {
        if (VersionUtil.getServerBukkitVersion().isLowerThan(VersionUtil.v1_14_R01)) {
            ((Ocelot)entity).setCatType(Ocelot.Type.valueOf((String)type.ocelotTypeName));
        } else {
            Class<?> cat = ReflUtil.getClassCached("org.bukkit.entity.Cat");
            Class<?> catType = ReflUtil.getClassCached("org.bukkit.entity.Cat$Type");
            Method setCatType = ReflUtil.getMethodCached(cat, "setCatType", catType);
            try {
                setCatType.invoke((Object)entity, EnumUtil.valueOf(catType, type.catTypeName));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void setVillagerProfession(Entity entity, VillagerProfession profession) {
        if (!(entity instanceof Villager)) {
            return;
        }
        Villager villager = (Villager)entity;
        villager.setProfession(profession.asEnum());
        if (VersionUtil.getServerBukkitVersion().isLowerThan(VersionUtil.v1_14_R01)) {
            Class<?> villagerCareer = ReflUtil.getClassCached("org.bukkit.entity.Villager$Career");
            Method setCareer = ReflUtil.getMethodCached(Villager.class, "setCareer", villagerCareer);
            try {
                setCareer.invoke((Object)entity, EnumUtil.valueOf(villagerCareer, profession.oldCareer));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void setVillagerType(Entity entity, String type) {
        if (VersionUtil.getServerBukkitVersion().isLowerThan(VersionUtil.v1_14_R01)) {
            return;
        }
        if (entity instanceof Villager) {
            ((Villager)entity).setVillagerType(Villager.Type.valueOf((String)type));
        }
    }

    public static void setLlamaColor(Entity entity, String color) {
        if (VersionUtil.getServerBukkitVersion().isLowerThan(VersionUtil.v1_11_R01)) {
            return;
        }
        if (entity instanceof Llama) {
            ((Llama)entity).setColor(Llama.Color.valueOf((String)color));
        }
    }

    public static void setParrotVariant(Entity entity, String variant) {
        if (VersionUtil.getServerBukkitVersion().isLowerThan(VersionUtil.v1_12_0_R01)) {
            return;
        }
        if (entity instanceof Parrot) {
            ((Parrot)entity).setVariant(Parrot.Variant.valueOf((String)variant));
        }
    }

    public static void setTropicalFishPattern(Entity entity, String pattern) {
        if (VersionUtil.getServerBukkitVersion().isLowerThan(VersionUtil.v1_12_0_R01)) {
            return;
        }
        if (entity instanceof TropicalFish) {
            ((TropicalFish)entity).setPattern(TropicalFish.Pattern.valueOf((String)pattern));
        }
    }

    public static void setMooshroomVariant(Entity entity, String variant) {
        if (VersionUtil.getServerBukkitVersion().isLowerThan(VersionUtil.v1_14_R01)) {
            return;
        }
        if (entity instanceof MushroomCow) {
            ((MushroomCow)entity).setVariant(MushroomCow.Variant.valueOf((String)variant));
        }
    }

    public static void setPandaGene(Entity entity, String gene, boolean mainGene) {
        if (VersionUtil.getServerBukkitVersion().isLowerThan(VersionUtil.v1_14_R01)) {
            return;
        }
        if (entity instanceof Panda) {
            Panda panda = (Panda)entity;
            Panda.Gene pandaGene = Panda.Gene.valueOf((String)gene);
            if (mainGene) {
                panda.setMainGene(pandaGene);
            } else {
                panda.setHiddenGene(pandaGene);
            }
        }
    }

    public static void setFoxType(Entity entity, String type) {
        if (VersionUtil.getServerBukkitVersion().isLowerThan(VersionUtil.v1_14_R01)) {
            return;
        }
        if (entity instanceof Fox) {
            ((Fox)entity).setFoxType(Fox.Type.valueOf((String)type));
        }
    }

    public static void setAxolotlVariant(Entity entity, String variant) {
        if (VersionUtil.getServerBukkitVersion().isLowerThan(VersionUtil.v1_17_R01)) {
            return;
        }
        if (entity instanceof Axolotl) {
            ((Axolotl)entity).setVariant(Axolotl.Variant.valueOf((String)variant));
        }
    }

    public static void setFrogVariant(Entity entity, String variant) {
        if (VersionUtil.getServerBukkitVersion().isLowerThan(VersionUtil.v1_19_R01)) {
            return;
        }
        if (entity instanceof Frog) {
            ((Frog)entity).setVariant(Frog.Variant.valueOf((String)variant));
        }
    }

    public static void setBoatVariant(Entity entity, BoatVariant variant) {
        if (VersionUtil.getServerBukkitVersion().isHigherThanOrEqualTo(VersionUtil.v1_21_3_R01) || VersionUtil.getServerBukkitVersion().isLowerThan(VersionUtil.v1_9_R01)) {
            return;
        }
        if (!(entity instanceof Boat)) {
            return;
        }
        Boat boat = (Boat)entity;
        if (VersionUtil.getServerBukkitVersion().isLowerThan(VersionUtil.v1_19_R01)) {
            boat.setWoodType(TreeSpecies.valueOf((String)variant.getTreeSpecies()));
        } else {
            boat.setBoatType(Boat.Type.valueOf((String)variant.getBoatType()));
        }
    }

    public static void setCamelSaddle(Entity entity, Player target) {
        if (VersionUtil.getServerBukkitVersion().isLowerThan(VersionUtil.v1_20_1_R01)) {
            return;
        }
        if (entity instanceof Camel) {
            Camel camel = (Camel)entity;
            camel.setTamed(true);
            camel.setOwner((AnimalTamer)target);
            camel.getInventory().setSaddle(new ItemStack(Material.SADDLE, 1));
        }
    }

    public static void setWolfVariant(Entity entity, String variant) {
        if (VersionUtil.getServerBukkitVersion().isLowerThan(VersionUtil.v1_20_6_R01)) {
            return;
        }
        if (entity instanceof Wolf) {
            Wolf wolf = (Wolf)entity;
            wolf.setVariant(RegistryUtil.valueOf(Wolf.Variant.class, variant));
        }
    }

    public static void setSalmonSize(Entity spawned, String s) {
        if (VersionUtil.getServerBukkitVersion().isLowerThan(VersionUtil.v1_21_3_R01)) {
            return;
        }
        if (spawned instanceof Salmon) {
            ((Salmon)spawned).setVariant(Salmon.Variant.valueOf((String)s));
        }
    }

    public static void setCowVariant(Entity spawned, String variant) {
        if (VersionUtil.getServerBukkitVersion().isLowerThan(VersionUtil.v1_21_5_R01) || COW_VARIANT_HANDLE == null) {
            return;
        }
        if (spawned instanceof Cow) {
            try {
                COW_VARIANT_HANDLE.invoke(spawned, RegistryUtil.valueOf(COW_VARIANT, variant));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void setChickenVariant(Entity spawned, String variant) {
        if (VersionUtil.getServerBukkitVersion().isLowerThan(VersionUtil.v1_21_5_R01)) {
            return;
        }
        if (spawned instanceof Chicken) {
            ((Chicken)spawned).setVariant(RegistryUtil.valueOf(Chicken.Variant.class, variant));
        }
    }

    public static void setPigVariant(Entity spawned, String variant) {
        if (VersionUtil.getServerBukkitVersion().isLowerThan(VersionUtil.v1_21_5_R01)) {
            return;
        }
        if (spawned instanceof Pig) {
            ((Pig)spawned).setVariant(RegistryUtil.valueOf(Pig.Variant.class, variant));
        }
    }

    static {
        MethodHandle handle = null;
        try {
            handle = MethodHandles.lookup().findVirtual(COW, "setVariant", MethodType.methodType(Void.TYPE, COW_VARIANT));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        COW_VARIANT_HANDLE = handle;
        LLAMA = EnumUtil.getEntityType("LLAMA");
        PARROT = EnumUtil.getEntityType("PARROT");
        TROPICAL_FISH = EnumUtil.getEntityType("TROPICAL_FISH");
        PANDA = EnumUtil.getEntityType("PANDA");
        TRADER_LLAMA = EnumUtil.getEntityType("TRADER_LLAMA");
        SHULKER = EnumUtil.getEntityType("SHULKER");
        STRAY = EnumUtil.getEntityType("STRAY");
        FOX = EnumUtil.getEntityType("FOX");
        PHANTOM = EnumUtil.getEntityType("PHANTOM");
        AXOLOTL = EnumUtil.getEntityType("AXOLOTL");
        GOAT = EnumUtil.getEntityType("GOAT");
        FROG = EnumUtil.getEntityType("FROG");
        CAMEL = EnumUtil.getEntityType("CAMEL");
        SALMON = EnumUtil.getEntityType("SALMON");
        CAT = EnumUtil.getEntityType("CAT", "OCELOT");
        ZOMBIFIED_PIGLIN = EnumUtil.getEntityType("ZOMBIFIED_PIGLIN", "PIG_ZOMBIE");
        MOOSHROOM = EnumUtil.getEntityType("MOOSHROOM", "MUSHROOM_COW");
        SNOW_GOLEM = EnumUtil.getEntityType("SNOW_GOLEM", "SNOWMAN");
        CHEST_MINECART = EnumUtil.getEntityType("CHEST_MINECART", "MINECART_CHEST");
        FURNACE_MINECART = EnumUtil.getEntityType("FURNACE_MINECART", "MINECART_FURNACE");
        TNT_MINECART = EnumUtil.getEntityType("TNT_MINECART", "MINECART_TNT");
        HOPPER_MINECART = EnumUtil.getEntityType("HOPPER_MINECART", "MINECART_HOPPER");
        SPAWNER_MINECART = EnumUtil.getEntityType("SPAWNER_MINECART", "MINECART_MOB_SPAWNER");
        END_CRYSTAL = EnumUtil.getEntityType("END_CRYSTAL", "ENDER_CRYSTAL");
        FIREWORK_ROCKET = EnumUtil.getEntityType("FIREWORK_ROCKET", "FIREWORK");
        OAK_BOAT = EnumUtil.getEntityType("BOAT", "OAK_BOAT");
    }

    public static enum CatType {
        SIAMESE("SIAMESE", "SIAMESE_CAT"),
        WHITE("WHITE", "SIAMESE_CAT"),
        RED("RED", "RED_CAT"),
        TABBY("TABBY", "RED_CAT"),
        TUXEDO("BLACK", "BLACK_CAT"),
        BRITISH_SHORTHAIR("BRITISH_SHORTHAIR", "SIAMESE_CAT"),
        CALICO("CALICO", "RED_CAT"),
        PERSIAN("PERSIAN", "RED_CAT"),
        RAGDOLL("RAGDOLL", "SIAMESE_CAT"),
        JELLIE("JELLIE", "SIAMESE_CAT"),
        BLACK("ALL_BLACK", "BLACK_CAT");

        private final String catTypeName;
        private final String ocelotTypeName;

        private CatType(String catTypeName, String ocelotTypeName) {
            this.catTypeName = catTypeName;
            this.ocelotTypeName = ocelotTypeName;
        }
    }

    public static enum VillagerProfession {
        NONE("FARMER", "FARMER", "NONE"),
        ARMORER("BLACKSMITH", "ARMORER"),
        BUTCHER("FARMER", "BUTCHER"),
        CARTOGRAPHER("LIBRARIAN", "CARTOGRAPHER"),
        CLERIC("PRIEST", "CLERIC"),
        FARMER("FARMER", "FARMER"),
        FISHERMAN("FARMER", "FISHERMAN"),
        FLETCHER("FARMER", "FLETCHER"),
        LEATHERWORKER("BUTCHER", "LEATHERWORKER"),
        LIBRARIAN("LIBRARIAN", "LIBRARIAN"),
        MASON(null, null, "MASON"),
        NITWIT("NITWIT", "NITWIT"),
        SHEPHERD("FARMER", "SHEPHERD"),
        TOOLSMITH("BLACKSMITH", "TOOL_SMITH", "TOOLSMITH"),
        WEAPONSMITH("BLACKSMITH", "WEAPON_SMITH", "WEAPONSMITH");

        private final String oldProfession;
        private final String oldCareer;
        private final String newProfession;

        private VillagerProfession(String oldProfession, String career) {
            this.oldProfession = oldProfession;
            this.oldCareer = career;
            this.newProfession = career;
        }

        private VillagerProfession(String oldProfession, String oldCareer, String newProfession) {
            this.oldProfession = oldProfession;
            this.oldCareer = oldCareer;
            this.newProfession = newProfession;
        }

        private Villager.Profession asEnum() {
            return RegistryUtil.valueOf(Villager.Profession.class, this.newProfession, this.oldProfession);
        }
    }

    public static enum BoatVariant {
        ACACIA("ACACIA", "ACACIA"),
        BIRCH("BIRCH", "BIRCH"),
        DARKOAK("DARK_OAK", "DARK_OAK"),
        GENERIC("GENERIC", "OAK"),
        JUNGLE("JUNGLE", "JUNGLE"),
        REDWOOD("REDWOOD", "SPRUCE"),
        OAK("GENERIC", "OAK"),
        SPRUCE("REDWOOD", "SPRUCE"),
        MANGROVE("GENERIC", "MANGROVE");

        private final String treeSpecies;
        private final String boatType;

        private BoatVariant(String treeSpecies, String boatType) {
            this.treeSpecies = treeSpecies;
            this.boatType = boatType;
        }

        public String getTreeSpecies() {
            return this.treeSpecies;
        }

        public String getBoatType() {
            return this.boatType;
        }
    }
}

