/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials;

import com.earth2me.essentials.Essentials;
import com.earth2me.essentials.paperlib.PaperLib;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import net.ess3.provider.Provider;
import net.essentialsx.providers.NullableProvider;
import net.essentialsx.providers.ProviderData;
import net.essentialsx.providers.ProviderTest;
import org.bukkit.plugin.Plugin;

public class ProviderFactory {
    private final Map<Class<? extends Provider>, Provider> providers = new HashMap<Class<? extends Provider>, Provider>();
    private final Map<Class<? extends Provider>, List<Class<? extends Provider>>> registeredProviders = new HashMap<Class<? extends Provider>, List<Class<? extends Provider>>>();
    private final Essentials essentials;

    public ProviderFactory(Essentials essentials) {
        this.essentials = essentials;
    }

    public <P extends Provider> P get(Class<P> providerClass) {
        Provider provider = this.providers.get(providerClass);
        if (provider == null) {
            return null;
        }
        return (P)provider;
    }

    @SafeVarargs
    public final void registerProvider(Class<? extends Provider> ... toRegister) {
        for (Class<? extends Provider> provider : toRegister) {
            Class<? extends Provider> superclass;
            Class<Provider> clazz = superclass = provider.getInterfaces().length > 0 ? provider.getInterfaces()[0] : provider.getSuperclass();
            if (!Provider.class.isAssignableFrom(superclass)) continue;
            this.registeredProviders.computeIfAbsent(superclass, k -> new ArrayList()).add(provider);
            if (!this.essentials.getSettings().isDebug()) continue;
            this.essentials.getLogger().info("Registered provider " + provider.getSimpleName() + " for " + superclass.getSimpleName());
        }
    }

    public void finalizeRegistration() {
        for (Map.Entry<Class<? extends Provider>, List<Class<? extends Provider>>> entry : this.registeredProviders.entrySet()) {
            Class<? extends Provider> providerClass = entry.getKey();
            boolean nullable = providerClass.isAnnotationPresent(NullableProvider.class);
            Class<? extends Provider> highestProvider = null;
            ProviderData highestProviderData = null;
            int highestWeight = -1;
            for (Class<? extends Provider> provider : entry.getValue()) {
                try {
                    ProviderData providerData = provider.getAnnotation(ProviderData.class);
                    if (providerData.weight() <= highestWeight || !this.testProvider(provider)) continue;
                    highestWeight = providerData.weight();
                    highestProvider = provider;
                    highestProviderData = providerData;
                }
                catch (Throwable e) {
                    this.essentials.getLogger().log(Level.SEVERE, "Failed to initialize provider " + provider.getName(), e);
                }
            }
            if (highestProvider != null) {
                this.essentials.getLogger().info("Selected " + highestProviderData.description() + " as the provider for " + providerClass.getSimpleName());
                this.providers.put(providerClass, this.getProviderInstance(highestProvider));
                continue;
            }
            if (!nullable) {
                throw new IllegalStateException("No provider found for " + providerClass.getName());
            }
            this.essentials.getLogger().info("No provider found for " + providerClass.getSimpleName() + ", but it is nullable");
        }
        this.registeredProviders.clear();
    }

    private boolean testProvider(Class<?> providerClass) throws InvocationTargetException, IllegalAccessException {
        try {
            for (Method method : providerClass.getMethods()) {
                if (!method.isAnnotationPresent(ProviderTest.class)) continue;
                return (Boolean)method.invoke(null, new Object[0]);
            }
            return true;
        }
        catch (NoClassDefFoundError ignored) {
            return false;
        }
    }

    private <P extends Provider> P getProviderInstance(Class<P> provider) {
        try {
            Constructor<?> constructor = provider.getConstructors()[0];
            if (constructor.getParameterTypes().length == 0) {
                return (P)((Provider)constructor.newInstance(new Object[0]));
            }
            Object[] args = new Object[constructor.getParameterTypes().length];
            for (int i = 0; i < args.length; ++i) {
                Class<Object> paramType = constructor.getParameterTypes()[i];
                if (paramType.isAssignableFrom(Plugin.class)) {
                    args[i] = this.essentials;
                    continue;
                }
                if (paramType.isAssignableFrom(Boolean.TYPE)) {
                    args[i] = PaperLib.isPaper();
                    continue;
                }
                throw new IllegalArgumentException("Unsupported parameter type " + paramType.getName());
            }
            return (P)((Provider)constructor.newInstance(args));
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            try {
                return (P)((Provider)provider.getConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                e.printStackTrace();
                throw new RuntimeException(ex);
            }
        }
    }
}

