/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials;

import com.earth2me.essentials.Essentials;
import com.earth2me.essentials.I18n;
import com.earth2me.essentials.IConf;
import com.earth2me.essentials.IUser;
import com.earth2me.essentials.commands.WarpNotFoundException;
import com.earth2me.essentials.config.EssentialsConfiguration;
import com.earth2me.essentials.utils.AdventureUtil;
import com.earth2me.essentials.utils.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import net.ess3.api.IWarps;
import net.ess3.api.InvalidNameException;
import net.ess3.api.TranslatableException;
import org.bukkit.Location;

public class Warps
implements IConf,
IWarps {
    private final Map<StringIgnoreCase, EssentialsConfiguration> warpPoints = new HashMap<StringIgnoreCase, EssentialsConfiguration>();
    private final File warpsFolder;

    public Warps(File dataFolder) {
        this.warpsFolder = new File(dataFolder, "warps");
        if (!this.warpsFolder.exists()) {
            this.warpsFolder.mkdirs();
        }
        this.reloadConfig();
    }

    @Override
    public boolean isEmpty() {
        return this.warpPoints.isEmpty();
    }

    @Override
    public boolean isWarp(String name) {
        return this.warpPoints.containsKey(new StringIgnoreCase(name));
    }

    @Override
    public Collection<String> getList() {
        ArrayList<String> keys = new ArrayList<String>();
        for (StringIgnoreCase stringIgnoreCase : this.warpPoints.keySet()) {
            keys.add(stringIgnoreCase.getString());
        }
        keys.sort(String.CASE_INSENSITIVE_ORDER);
        return keys;
    }

    @Override
    public Location getWarp(String warp) throws WarpNotFoundException {
        EssentialsConfiguration conf = this.warpPoints.get(new StringIgnoreCase(warp));
        if (conf == null) {
            throw new WarpNotFoundException();
        }
        Location loc = conf.getLocation(null).location();
        if (loc == null) {
            throw new WarpNotFoundException();
        }
        return loc;
    }

    @Override
    public void setWarp(String name, Location loc) throws Exception {
        this.setWarp(null, name, loc);
    }

    @Override
    public void setWarp(IUser user, String name, Location loc) throws Exception {
        String filename = StringUtil.sanitizeFileName(name);
        EssentialsConfiguration conf = this.warpPoints.get(new StringIgnoreCase(name));
        if (conf == null) {
            File confFile = new File(this.warpsFolder, filename + ".yml");
            if (confFile.exists()) {
                throw new TranslatableException("similarWarpExist", new Object[0]);
            }
            conf = new EssentialsConfiguration(confFile);
            conf.load();
            this.warpPoints.put(new StringIgnoreCase(name), conf);
        }
        conf.setProperty(null, loc);
        conf.setProperty("name", name);
        if (user != null) {
            conf.setProperty("lastowner", user.getBase().getUniqueId().toString());
        }
        conf.save();
    }

    @Override
    public UUID getLastOwner(String warp) throws WarpNotFoundException {
        EssentialsConfiguration conf = this.warpPoints.get(new StringIgnoreCase(warp));
        if (conf == null) {
            throw new WarpNotFoundException();
        }
        UUID uuid = null;
        try {
            uuid = UUID.fromString(conf.getString("lastowner", null));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return uuid;
    }

    @Override
    public void removeWarp(String name) throws Exception {
        EssentialsConfiguration conf = this.warpPoints.get(new StringIgnoreCase(name));
        if (conf == null) {
            throw new TranslatableException("warpNotExist", new Object[0]);
        }
        if (!conf.getFile().delete()) {
            throw new TranslatableException("warpDeleteError", new Object[0]);
        }
        this.warpPoints.remove(new StringIgnoreCase(name));
    }

    @Override
    public final void reloadConfig() {
        this.warpPoints.clear();
        File[] listOfFiles = this.warpsFolder.listFiles();
        if (listOfFiles != null) {
            for (File listOfFile : listOfFiles) {
                String filename = listOfFile.getName();
                if (!listOfFile.isFile() || !filename.endsWith(".yml")) continue;
                try {
                    EssentialsConfiguration conf = new EssentialsConfiguration(listOfFile);
                    conf.load();
                    String name = conf.getString("name", null);
                    if (name == null || !conf.hasProperty("world")) continue;
                    this.warpPoints.put(new StringIgnoreCase(name), conf);
                }
                catch (Exception ex) {
                    Essentials.getWrappedLogger().log(Level.WARNING, AdventureUtil.miniToLegacy(I18n.tlLiteral("loadWarpError", filename)), ex);
                }
            }
        }
    }

    @Override
    @Deprecated
    public File getWarpFile(String name) throws InvalidNameException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getCount() {
        return this.getList().size();
    }

    private static class StringIgnoreCase {
        private final String string;

        StringIgnoreCase(String string) {
            this.string = string;
        }

        public int hashCode() {
            return this.getString().toLowerCase(Locale.ENGLISH).hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof StringIgnoreCase) {
                return this.getString().equalsIgnoreCase(((StringIgnoreCase)o).getString());
            }
            return false;
        }

        public String getString() {
            return this.string;
        }
    }
}

