/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.CommandSource;
import com.earth2me.essentials.IUser;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsLoopCommand;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.bukkit.GameMode;
import org.bukkit.Server;

public class Commandgamemode
extends EssentialsLoopCommand {
    private final List<String> STANDARD_OPTIONS = ImmutableList.of((Object)"creative", (Object)"survival", (Object)"adventure", (Object)"spectator", (Object)"toggle");

    public Commandgamemode() {
        super("gamemode");
    }

    @Override
    protected void run(Server server, CommandSource sender, String commandLabel, String[] args) throws Exception {
        if (args.length == 0) {
            throw new NotEnoughArgumentsException();
        }
        if (args.length == 1) {
            this.loopOnlinePlayersConsumer(server, sender, false, true, args[0], user -> this.setUserGamemode(sender, this.matchGameMode(commandLabel), user));
        } else if (args.length == 2) {
            this.loopOnlinePlayersConsumer(server, sender, false, true, args[1], user -> this.setUserGamemode(sender, this.matchGameMode(args[0]), user));
        }
    }

    @Override
    protected void run(Server server, User user, String commandLabel, String[] args) throws Exception {
        GameMode gameMode;
        if (args.length == 0) {
            gameMode = this.matchGameMode(commandLabel);
        } else {
            if (args.length > 1 && args[1].trim().length() > 2 && user.isAuthorized("essentials.gamemode.others")) {
                this.loopOnlinePlayersConsumer(server, user.getSource(), false, true, args[1], player -> this.setUserGamemode(user.getSource(), this.matchGameMode(args[0].toLowerCase(Locale.ENGLISH)), player));
                return;
            }
            try {
                gameMode = this.matchGameMode(args[0].toLowerCase(Locale.ENGLISH));
            }
            catch (NotEnoughArgumentsException e) {
                if (user.isAuthorized("essentials.gamemode.others")) {
                    this.loopOnlinePlayersConsumer(server, user.getSource(), false, true, args[0], player -> this.setUserGamemode(user.getSource(), this.matchGameMode(commandLabel), player));
                    return;
                }
                throw new NotEnoughArgumentsException();
            }
        }
        if (gameMode == null) {
            GameMode gameMode2 = user.getBase().getGameMode() == GameMode.SURVIVAL ? GameMode.CREATIVE : (gameMode = user.getBase().getGameMode() == GameMode.CREATIVE ? GameMode.ADVENTURE : GameMode.SURVIVAL);
        }
        if (this.isProhibitedChange(user, gameMode)) {
            user.sendTl("cantGamemode", user.playerTl(gameMode.toString().toLowerCase(Locale.ENGLISH), new Object[0]));
            return;
        }
        user.getBase().setGameMode(gameMode);
        user.sendTl("gameMode", user.playerTl(user.getBase().getGameMode().toString().toLowerCase(Locale.ENGLISH), new Object[0]), user.getDisplayName());
    }

    private void setUserGamemode(CommandSource sender, GameMode gameMode, User user) throws NotEnoughArgumentsException {
        if (gameMode == null) {
            throw new NotEnoughArgumentsException(sender.tl("gameModeInvalid", new Object[0]));
        }
        if (sender.isPlayer() && this.isProhibitedChange(sender.getUser(), gameMode)) {
            sender.sendTl("cantGamemode", gameMode.name());
            return;
        }
        user.getBase().setGameMode(gameMode);
        sender.sendTl("gameMode", sender.tl(gameMode.toString().toLowerCase(Locale.ENGLISH), new Object[0]), user.getDisplayName());
    }

    private boolean isProhibitedChange(IUser user, GameMode to) {
        return user != null && !user.isAuthorized("essentials.gamemode.all") && !user.isAuthorized("essentials.gamemode." + to.name().toLowerCase());
    }

    private GameMode matchGameMode(String modeString) throws NotEnoughArgumentsException {
        GameMode mode = null;
        if ((modeString = modeString.toLowerCase()).equalsIgnoreCase("gmc") || modeString.equalsIgnoreCase("egmc") || modeString.contains("creat") || modeString.equalsIgnoreCase("1") || modeString.equalsIgnoreCase("c")) {
            mode = GameMode.CREATIVE;
        } else if (modeString.equalsIgnoreCase("gms") || modeString.equalsIgnoreCase("egms") || modeString.contains("survi") || modeString.equalsIgnoreCase("0") || modeString.equalsIgnoreCase("s")) {
            mode = GameMode.SURVIVAL;
        } else if (modeString.equalsIgnoreCase("gma") || modeString.equalsIgnoreCase("egma") || modeString.contains("advent") || modeString.equalsIgnoreCase("2") || modeString.equalsIgnoreCase("a")) {
            mode = GameMode.ADVENTURE;
        } else if (modeString.equalsIgnoreCase("gmsp") || modeString.equalsIgnoreCase("egmsp") || modeString.contains("spec") || modeString.equalsIgnoreCase("3") || modeString.equalsIgnoreCase("sp")) {
            mode = GameMode.SPECTATOR;
        } else if (!(modeString.equalsIgnoreCase("gmt") || modeString.equalsIgnoreCase("egmt") || modeString.contains("toggle") || modeString.contains("cycle") || modeString.equalsIgnoreCase("t"))) {
            throw new NotEnoughArgumentsException();
        }
        return mode;
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, CommandSource sender, String commandLabel, String[] args) {
        if (args.length == 1) {
            try {
                this.matchGameMode(commandLabel);
                return this.getPlayers(server, sender);
            }
            catch (NotEnoughArgumentsException e) {
                return this.STANDARD_OPTIONS;
            }
        }
        if (args.length == 2) {
            return this.getPlayers(server, sender);
        }
        return Collections.emptyList();
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, User user, String commandLabel, String[] args) {
        boolean isDirectGamemodeCommand;
        try {
            this.matchGameMode(commandLabel);
            isDirectGamemodeCommand = true;
        }
        catch (NotEnoughArgumentsException ex) {
            isDirectGamemodeCommand = false;
        }
        if (args.length == 1) {
            if (user.isAuthorized("essentials.gamemode.others") && isDirectGamemodeCommand) {
                return this.getPlayers(server, user);
            }
            return this.STANDARD_OPTIONS;
        }
        if (args.length == 2 && user.isAuthorized("essentials.gamemode.others") && !isDirectGamemodeCommand) {
            return this.getPlayers(server, user);
        }
        return Collections.emptyList();
    }

    @Override
    protected void updatePlayer(Server server, CommandSource sender, User user, String[] args) {
    }
}

