/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.CommandSource;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import com.earth2me.essentials.commands.WorldNameComparator;
import com.earth2me.essentials.libs.kyori.adventure.text.Component;
import com.earth2me.essentials.utils.AdventureUtil;
import com.earth2me.essentials.utils.DescParseTickFormat;
import com.earth2me.essentials.utils.NumberUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.StringJoiner;
import java.util.TreeSet;
import net.ess3.api.TranslatableException;
import org.bukkit.Server;
import org.bukkit.World;

public class Commandtime
extends EssentialsCommand {
    private final List<String> subCommands = Arrays.asList("add", "set");
    private final List<String> timeNames = Arrays.asList("sunrise", "day", "morning", "noon", "afternoon", "sunset", "night", "midnight");
    private final List<String> timeNumbers = Arrays.asList("1000", "2000", "3000", "4000", "5000");

    public Commandtime() {
        super("time");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run(Server server, CommandSource sender, String commandLabel, String[] args) throws Exception {
        long timeTick;
        Set<World> worlds;
        boolean add = false;
        if (args.length == 0) {
            worlds = this.getWorlds(server, sender, null);
            if (!commandLabel.endsWith("day") && !commandLabel.endsWith("night")) {
                this.getWorldsTime(sender, worlds);
                return;
            }
            timeTick = DescParseTickFormat.parse(commandLabel.toLowerCase(Locale.ENGLISH).replace("e", ""));
        } else {
            if (args.length == 1) {
                worlds = this.getWorlds(server, sender, null);
                try {
                    timeTick = DescParseTickFormat.parse(NumberUtil.isInt(args[0]) ? args[0] + "t" : args[0]);
                }
                catch (NumberFormatException e) {
                    throw new NotEnoughArgumentsException(e);
                }
            }
            if (args[0].equalsIgnoreCase("set") || args[0].equalsIgnoreCase("add")) {
                try {
                    add = args[0].equalsIgnoreCase("add");
                    timeTick = DescParseTickFormat.parse(NumberUtil.isInt(args[1]) ? args[1] + "t" : args[1]);
                    worlds = this.getWorlds(server, sender, args.length > 2 ? args[2] : null);
                }
                catch (NumberFormatException e) {
                    throw new NotEnoughArgumentsException(e);
                }
            }
            try {
                timeTick = DescParseTickFormat.parse(NumberUtil.isInt(args[0]) ? args[0] + "t" : args[0]);
                worlds = this.getWorlds(server, sender, args[1]);
            }
            catch (NumberFormatException e) {
                throw new NotEnoughArgumentsException(e);
            }
        }
        if (!sender.isAuthorized("essentials.time.set")) {
            throw new TranslatableException("timeSetPermission", new Object[0]);
        }
        for (World world : worlds) {
            if (this.canUpdateWorld(sender, world)) continue;
            throw new TranslatableException("timeSetWorldPermission", sender.getUser().getBase().getWorld().getName());
        }
        StringJoiner joiner = new StringJoiner(", ");
        for (World world : worlds) {
            long time = world.getTime();
            if (!add) {
                time -= time % 24000L;
            }
            world.setTime(time + (long)(add ? 0 : 24000) + timeTick);
            joiner.add(world.getName());
        }
        sender.sendTl(add ? "timeWorldAdd" : "timeWorldSet", DescParseTickFormat.formatTicks(timeTick), joiner.toString());
    }

    private void getWorldsTime(CommandSource sender, Collection<World> worlds) {
        if (worlds.size() == 1) {
            Iterator<World> iter = worlds.iterator();
            sender.sendComponent((Component)AdventureUtil.miniMessage().deserialize(DescParseTickFormat.format(iter.next().getTime())));
            return;
        }
        for (World world : worlds) {
            sender.sendTl("timeWorldCurrent", world.getName(), AdventureUtil.parsed(DescParseTickFormat.format(world.getTime())));
        }
    }

    private Set<World> getWorlds(Server server, CommandSource sender, String selector) throws Exception {
        TreeSet<World> worlds = new TreeSet<World>(new WorldNameComparator());
        if (selector == null) {
            if (sender.isPlayer()) {
                worlds.add(sender.getPlayer().getWorld());
            } else {
                worlds.addAll(server.getWorlds());
            }
            return worlds;
        }
        World world = server.getWorld(selector);
        if (world != null) {
            worlds.add(world);
        } else if (selector.equalsIgnoreCase("*") || selector.equalsIgnoreCase("all")) {
            worlds.addAll(server.getWorlds());
        } else {
            throw new TranslatableException("invalidWorld", new Object[0]);
        }
        return worlds;
    }

    private boolean canUpdateAll(CommandSource sender) {
        return !this.ess.getSettings().isWorldTimePermissions() || sender.isAuthorized("essentials.time.world.all");
    }

    private boolean canUpdateWorld(CommandSource sender, World world) {
        return this.canUpdateAll(sender) || sender.isAuthorized("essentials.time.world." + this.normalizeWorldName(world));
    }

    private String normalizeWorldName(World world) {
        return world.getName().toLowerCase().replaceAll("\\s+", "_");
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, CommandSource sender, String commandLabel, String[] args) {
        if (args.length == 1) {
            if (sender.isAuthorized("essentials.time.set")) {
                return this.subCommands;
            }
            return Collections.emptyList();
        }
        if (args.length == 2) {
            if (args[0].equalsIgnoreCase("set")) {
                return this.timeNames;
            }
            if (args[0].equalsIgnoreCase("add")) {
                return this.timeNumbers;
            }
            return Collections.emptyList();
        }
        if (args.length == 3 && (args[0].equalsIgnoreCase("set") || args[0].equalsIgnoreCase("add"))) {
            ArrayList worlds = Lists.newArrayList();
            for (World world : server.getWorlds()) {
                if (!sender.isAuthorized("essentials.time.world." + this.normalizeWorldName(world))) continue;
                worlds.add(world.getName());
            }
            if (sender.isAuthorized("essentials.time.world.all")) {
                worlds.add("*");
            }
            return worlds;
        }
        return Collections.emptyList();
    }
}

