/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.CommandSource;
import com.earth2me.essentials.RandomTeleport;
import com.earth2me.essentials.Trade;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.NoChargeException;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.ess3.api.TranslatableException;
import net.ess3.api.events.UserRandomTeleportEvent;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerTeleportEvent;

public class Commandtpr
extends EssentialsCommand {
    public Commandtpr() {
        super("tpr");
    }

    @Override
    protected void run(Server server, User user, String commandLabel, String[] args) throws Exception {
        User target;
        String randomLocationName;
        Trade charge = new Trade(this.getName(), this.ess);
        charge.isAffordableFor(user);
        RandomTeleport randomTeleport = this.ess.getRandomTeleport();
        if (args.length == 0) {
            randomLocationName = randomTeleport.getDefaultLocation().replace("{world}", user.getLocation().getWorld().getName());
            target = user;
        } else {
            randomLocationName = args[0];
            if (!randomTeleport.hasLocation(randomLocationName)) {
                throw new TranslatableException("tprNotExist", new Object[0]);
            }
            if (randomTeleport.isPerLocationPermission() && !user.isAuthorized("essentials.tpr.location." + randomLocationName)) {
                throw new TranslatableException("tprNoPermission", new Object[0]);
            }
            target = args.length > 1 && user.isAuthorized("essentials.tpr.others") ? this.getPlayer(server, user, args, 1) : user;
        }
        UserRandomTeleportEvent event = new UserRandomTeleportEvent(target, randomLocationName, randomTeleport.getCenter(randomLocationName), randomTeleport.getMinRange(randomLocationName), randomTeleport.getMaxRange(randomLocationName));
        server.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        target.sendTl("tprSuccess", new Object[0]);
        if (target != user) {
            user.sendTl("tprOtherUser", target.getDisplayName());
        }
        (event.isModified() ? randomTeleport.getRandomLocation(event.getCenter(), event.getMinRange(), event.getMaxRange()) : randomTeleport.getRandomLocation(randomLocationName)).thenAccept(location -> {
            CompletableFuture<Boolean> future = this.getNewExceptionFuture(user.getSource(), commandLabel);
            future.thenAccept(success -> {
                if (success.booleanValue()) {
                    target.sendTl("tprSuccessDone", new Object[0]);
                }
            });
            target.getAsyncTeleport().teleport((Location)location, charge, PlayerTeleportEvent.TeleportCause.COMMAND, future);
        });
        throw new NoChargeException();
    }

    @Override
    protected void run(Server server, CommandSource sender, String commandLabel, String[] args) throws Exception {
        if (args.length < 2) {
            throw new NotEnoughArgumentsException();
        }
        RandomTeleport randomTeleport = this.ess.getRandomTeleport();
        User userToTeleport = this.getPlayer(server, sender, args, 1);
        String potentialLocation = args[0];
        if (!randomTeleport.hasLocation(potentialLocation)) {
            throw new TranslatableException("tprNotExist", new Object[0]);
        }
        UserRandomTeleportEvent event = new UserRandomTeleportEvent(userToTeleport, potentialLocation, randomTeleport.getCenter(potentialLocation), randomTeleport.getMinRange(potentialLocation), randomTeleport.getMaxRange(potentialLocation));
        server.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        userToTeleport.sendTl("tprSuccess", new Object[0]);
        sender.sendTl("tprOtherUser", userToTeleport.getDisplayName());
        (event.isModified() ? randomTeleport.getRandomLocation(event.getCenter(), event.getMinRange(), event.getMaxRange()) : randomTeleport.getRandomLocation(potentialLocation)).thenAccept(location -> {
            CompletableFuture<Boolean> future = this.getNewExceptionFuture(sender, commandLabel);
            future.thenAccept(success -> {
                if (success.booleanValue()) {
                    userToTeleport.sendTl("tprSuccessDone", new Object[0]);
                }
            });
            userToTeleport.getAsyncTeleport().now((Location)location, false, PlayerTeleportEvent.TeleportCause.COMMAND, future);
        });
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, CommandSource sender, String commandLabel, String[] args) {
        RandomTeleport randomTeleport = this.ess.getRandomTeleport();
        if (args.length == 1) {
            if (randomTeleport.isPerLocationPermission()) {
                return randomTeleport.listLocations().stream().filter(name -> sender.isAuthorized("essentials.tpr.location." + name)).collect(Collectors.toList());
            }
            return randomTeleport.listLocations();
        }
        if (args.length == 2 && sender.isAuthorized("essentials.tpr.others")) {
            return this.getPlayers(server, sender);
        }
        return Collections.emptyList();
    }
}

