/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.config.holders;

import com.earth2me.essentials.config.annotations.DeleteIfIncomplete;
import com.earth2me.essentials.config.annotations.DeleteOnEmpty;
import com.earth2me.essentials.config.entities.CommandCooldown;
import com.earth2me.essentials.config.entities.LazyLocation;
import com.earth2me.essentials.libs.checkerframework.checker.nullness.qual.MonotonicNonNull;
import com.earth2me.essentials.libs.checkerframework.checker.nullness.qual.NonNull;
import com.earth2me.essentials.libs.checkerframework.checker.nullness.qual.Nullable;
import com.earth2me.essentials.libs.configurate.objectmapping.ConfigSerializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.essentialsx.api.v2.services.mail.MailMessage;
import org.bukkit.Location;
import org.bukkit.Material;

@ConfigSerializable
public class UserConfigHolder {
    private @MonotonicNonNull BigDecimal money;
    @DeleteOnEmpty
    private @MonotonicNonNull Map<String, LazyLocation> homes;
    private @Nullable String nickname;
    @DeleteOnEmpty
    private @MonotonicNonNull Set<Material> unlimited;
    @DeleteOnEmpty
    private @MonotonicNonNull Map<String, List<String>> powertools;
    private @MonotonicNonNull LazyLocation lastlocation;
    private @MonotonicNonNull LazyLocation logoutlocation;
    private @Nullable String jail;
    @DeleteOnEmpty
    private @MonotonicNonNull ArrayList<MailMessage> mail;
    private boolean teleportenabled = true;
    private boolean teleportauto = false;
    @DeleteOnEmpty
    private @MonotonicNonNull List<UUID> ignore;
    private boolean godmode = false;
    private boolean muted = false;
    private @Nullable String muteReason;
    private boolean jailed = false;
    private @NonNull String ipAddress = "";
    private boolean afk = false;
    @DeleteOnEmpty
    private @Nullable String geolocation;
    private boolean socialspy = false;
    private boolean npc = false;
    private @MonotonicNonNull String lastAccountName;
    private @MonotonicNonNull String npcName;
    private boolean powertoolsenabled = true;
    private boolean acceptingPay = true;
    private @Nullable Boolean confirmPay;
    private @Nullable Boolean confirmClear;
    private @Nullable Boolean lastMessageReplyRecipient;
    private boolean baltopExempt = false;
    private @MonotonicNonNull Boolean shouting;
    @DeleteOnEmpty
    private @MonotonicNonNull List<String> pastUsernames;
    private @NonNull Timestamps timestamps = new Timestamps();

    public BigDecimal money() {
        return this.money;
    }

    public void money(BigDecimal value) {
        this.money = value;
    }

    public Map<String, LazyLocation> homes() {
        if (this.homes == null) {
            this.homes = new HashMap<String, LazyLocation>();
        }
        return this.homes;
    }

    public void homes(Map<String, LazyLocation> value) {
        this.homes = value;
    }

    public String nickname() {
        return this.nickname;
    }

    public void nickname(String value) {
        this.nickname = value;
    }

    public Set<Material> unlimited() {
        if (this.unlimited == null) {
            this.unlimited = new HashSet<Material>();
        }
        return this.unlimited;
    }

    public Map<String, List<String>> powertools() {
        if (this.powertools == null) {
            this.powertools = new HashMap<String, List<String>>();
        }
        return this.powertools;
    }

    public LazyLocation lastLocation() {
        return this.lastlocation;
    }

    public void lastLocation(Location value) {
        if (value == null || value.getWorld() == null) {
            return;
        }
        this.lastlocation = LazyLocation.fromLocation(value);
    }

    public LazyLocation logoutLocation() {
        return this.logoutlocation;
    }

    public void logoutLocation(Location value) {
        if (value == null || value.getWorld() == null) {
            return;
        }
        this.logoutlocation = LazyLocation.fromLocation(value);
    }

    public String jail() {
        return this.jail;
    }

    public void jail(String value) {
        this.jail = value;
    }

    public ArrayList<MailMessage> mail() {
        if (this.mail == null) {
            this.mail = new ArrayList();
        }
        return this.mail;
    }

    public void mail(ArrayList<MailMessage> value) {
        this.mail = value;
    }

    public boolean teleportEnabled() {
        return this.teleportenabled;
    }

    public void teleportEnabled(boolean value) {
        this.teleportenabled = value;
    }

    public boolean teleportAuto() {
        return this.teleportauto;
    }

    public void teleportAuto(boolean value) {
        this.teleportauto = value;
    }

    public List<UUID> ignore() {
        if (this.ignore == null) {
            this.ignore = new ArrayList<UUID>();
        }
        return this.ignore;
    }

    public void ignore(List<UUID> value) {
        this.ignore = value;
    }

    public boolean godMode() {
        return this.godmode;
    }

    public void godMode(boolean value) {
        this.godmode = value;
    }

    public boolean muted() {
        return this.muted;
    }

    public void muted(boolean value) {
        this.muted = value;
    }

    public String muteReason() {
        return this.muteReason;
    }

    public void muteReason(String value) {
        this.muteReason = value;
    }

    public boolean jailed() {
        return this.jailed;
    }

    public void jailed(boolean value) {
        this.jailed = value;
    }

    public String ipAddress() {
        return this.ipAddress;
    }

    public void ipAddress(String value) {
        this.ipAddress = value;
    }

    public boolean afk() {
        return this.afk;
    }

    public void afk(boolean value) {
        this.afk = value;
    }

    public String geolocation() {
        return this.geolocation;
    }

    public void geolocation(String value) {
        this.geolocation = value;
    }

    public boolean socialSpy() {
        return this.socialspy;
    }

    public void socialSpy(boolean value) {
        this.socialspy = value;
    }

    public boolean npc() {
        return this.npc;
    }

    public void npc(boolean value) {
        this.npc = value;
    }

    public String lastAccountName() {
        return this.lastAccountName;
    }

    public void lastAccountName(String value) {
        this.lastAccountName = value;
    }

    public String npcName() {
        return this.npcName;
    }

    public void npcName(String value) {
        this.npcName = value;
    }

    public boolean powerToolsEnabled() {
        return this.powertoolsenabled;
    }

    public void powerToolsEnabled(boolean value) {
        this.powertoolsenabled = value;
    }

    public boolean acceptingPay() {
        return this.acceptingPay;
    }

    public void acceptingPay(boolean value) {
        this.acceptingPay = value;
    }

    public Boolean confirmPay() {
        return this.confirmPay;
    }

    public void confirmPay(Boolean value) {
        this.confirmPay = value;
    }

    public Boolean confirmClear() {
        return this.confirmClear;
    }

    public void confirmClear(Boolean value) {
        this.confirmClear = value;
    }

    public Boolean lastMessageReplyRecipient() {
        return this.lastMessageReplyRecipient;
    }

    public void lastMessageReplyRecipient(Boolean value) {
        this.lastMessageReplyRecipient = value;
    }

    public boolean baltopExempt() {
        return this.baltopExempt;
    }

    public void baltopExempt(boolean value) {
        this.baltopExempt = value;
    }

    public Boolean shouting() {
        return this.shouting;
    }

    public void shouting(Boolean value) {
        this.shouting = value;
    }

    public List<String> pastUsernames() {
        if (this.pastUsernames == null) {
            this.pastUsernames = new ArrayList<String>();
        }
        return this.pastUsernames;
    }

    public void pastUsernames(List<String> value) {
        this.pastUsernames = value;
    }

    public Timestamps timestamps() {
        return this.timestamps;
    }

    @ConfigSerializable
    public static class Timestamps {
        private long lastteleport = 0L;
        private long lastheal = 0L;
        private long mute = 0L;
        private long jail = 0L;
        private long onlinejail = 0L;
        private long logout = 0L;
        private long login = 0L;
        @DeleteOnEmpty
        private @MonotonicNonNull Map<String, Long> kits;
        @DeleteOnEmpty
        @DeleteIfIncomplete
        private @MonotonicNonNull List<CommandCooldown> commandCooldowns;

        public long lastTeleport() {
            return this.lastteleport;
        }

        public void lastTeleport(long value) {
            this.lastteleport = value;
        }

        public long lastHeal() {
            return this.lastheal;
        }

        public void lastHeal(long value) {
            this.lastheal = value;
        }

        public long mute() {
            return this.mute;
        }

        public void mute(long value) {
            this.mute = value;
        }

        public long jail() {
            return this.jail;
        }

        public void jail(long value) {
            this.jail = value;
        }

        public long onlineJail() {
            return this.onlinejail;
        }

        public void onlineJail(long value) {
            this.onlinejail = value;
        }

        public long logout() {
            return this.logout;
        }

        public void logout(long value) {
            this.logout = value;
        }

        public long login() {
            return this.login;
        }

        public void login(long value) {
            this.login = value;
        }

        public Map<String, Long> kits() {
            if (this.kits == null) {
                this.kits = new HashMap<String, Long>();
            }
            return this.kits;
        }

        public void kits(Map<String, Long> value) {
            this.kits = value;
        }

        public List<CommandCooldown> commandCooldowns() {
            if (this.commandCooldowns == null) {
                this.commandCooldowns = new ArrayList<CommandCooldown>();
            }
            return this.commandCooldowns;
        }

        public void commandCooldowns(List<CommandCooldown> value) {
            this.commandCooldowns = value;
        }
    }
}

