/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.config.serializers;

import com.earth2me.essentials.libs.configurate.serialize.ScalarSerializer;
import com.earth2me.essentials.libs.configurate.serialize.SerializationException;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.function.Predicate;

public class BigDecimalTypeSerializer
extends ScalarSerializer<BigDecimal> {
    public BigDecimalTypeSerializer() {
        super(BigDecimal.class);
    }

    @Override
    public BigDecimal deserialize(Type type, Object obj) throws SerializationException {
        if (obj instanceof Double) {
            return BigDecimal.valueOf((Double)obj);
        }
        if (obj instanceof Integer) {
            return BigDecimal.valueOf(((Integer)obj).intValue());
        }
        if (obj instanceof Long) {
            return BigDecimal.valueOf((Long)obj);
        }
        if (obj instanceof BigInteger) {
            return new BigDecimal((BigInteger)obj);
        }
        if (obj instanceof String) {
            try {
                return new BigDecimal((String)obj, MathContext.DECIMAL128);
            }
            catch (ArithmeticException | NumberFormatException e) {
                throw new SerializationException(type, "Failed to coerce input value of type " + obj.getClass() + " to BigDecimal", (Throwable)e);
            }
        }
        throw new SerializationException(type, "Failed to coerce input value of type " + obj.getClass() + " to BigDecimal");
    }

    @Override
    protected Object serialize(BigDecimal item, Predicate<Class<?>> typeSupported) {
        return item.toString();
    }
}

