/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.libs.configurate.serialize;

import com.earth2me.essentials.libs.checkerframework.checker.nullness.qual.Nullable;
import com.earth2me.essentials.libs.configurate.ConfigurateException;
import com.earth2me.essentials.libs.configurate.ConfigurationNode;
import com.earth2me.essentials.libs.configurate.NodePath;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Type;

public class SerializationException
extends ConfigurateException {
    public static final long serialVersionUID = -910568375387191784L;
    private transient @Nullable Type expectedType;

    public SerializationException() {
    }

    public SerializationException(String message) {
        super(message);
    }

    public SerializationException(Throwable cause) {
        super(cause);
    }

    public SerializationException(Type expectedType, String message) {
        super(message);
        this.expectedType = expectedType;
    }

    public SerializationException(AnnotatedType expectedType, String message) {
        super(message);
        this.expectedType = expectedType.getType();
    }

    public SerializationException(Type expectedType, Throwable cause) {
        super(cause);
        this.expectedType = expectedType;
    }

    public SerializationException(AnnotatedType expectedType, Throwable cause) {
        super(cause);
        this.expectedType = expectedType.getType();
    }

    public SerializationException(Type expectedType, String message, Throwable cause) {
        super(message, cause);
        this.expectedType = expectedType;
    }

    public SerializationException(AnnotatedType expectedType, String message, Throwable cause) {
        super(message, cause);
        this.expectedType = expectedType.getType();
    }

    public SerializationException(ConfigurationNode node, Type expectedType, String message) {
        this(node, expectedType, message, null);
    }

    public SerializationException(ConfigurationNode node, AnnotatedType expectedType, String message) {
        this(node, expectedType, message, null);
    }

    public SerializationException(ConfigurationNode node, Type expectedType, Throwable cause) {
        this(node, expectedType, null, cause);
    }

    public SerializationException(ConfigurationNode node, AnnotatedType expectedType, Throwable cause) {
        this(node, expectedType, null, cause);
    }

    public SerializationException(ConfigurationNode node, Type expectedType, @Nullable String message, @Nullable Throwable cause) {
        super(node, message, cause);
        this.expectedType = expectedType;
    }

    public SerializationException(ConfigurationNode node, AnnotatedType expectedType, @Nullable String message, @Nullable Throwable cause) {
        super(node, message, cause);
        this.expectedType = expectedType.getType();
    }

    public SerializationException(NodePath path, Type expectedType, String message) {
        super(path, message, null);
        this.expectedType = expectedType;
    }

    public SerializationException(NodePath path, AnnotatedType expectedType, String message) {
        super(path, message, null);
        this.expectedType = expectedType.getType();
    }

    public @Nullable Type expectedType() {
        return this.expectedType;
    }

    @Override
    public @Nullable String getMessage() {
        if (this.expectedType == null) {
            return super.getMessage();
        }
        return this.path() + " of type " + this.expectedType.getTypeName() + ": " + this.rawMessage();
    }

    public void initType(Type type) {
        if (this.expectedType == null) {
            this.expectedType = type;
        }
    }

    public final void initType(AnnotatedType type) {
        if (this.expectedType == null) {
            this.expectedType = type.getType();
        }
    }
}

