/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.perm.impl;

import com.earth2me.essentials.Essentials;
import com.earth2me.essentials.User;
import com.earth2me.essentials.perm.impl.ModernVaultHandler;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.context.ContextCalculator;
import net.luckperms.api.context.ContextConsumer;
import net.luckperms.api.context.ContextSet;
import net.luckperms.api.context.ImmutableContextSet;
import net.luckperms.api.model.group.Group;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.RegisteredServiceProvider;

public class LuckPermsHandler
extends ModernVaultHandler {
    private LuckPerms luckPerms;
    private Essentials ess;
    private CombinedCalculator calculator;

    @Override
    public void registerContext(String context, Function<User, Iterable<String>> calculator, Supplier<Iterable<String>> suggestions) {
        if (this.calculator == null) {
            this.calculator = new CombinedCalculator();
            this.luckPerms.getContextManager().registerCalculator((ContextCalculator)this.calculator);
        }
        this.calculator.calculators.add(new Calculator(context, calculator, suggestions));
    }

    @Override
    public void unregisterContexts() {
        if (this.calculator != null) {
            this.luckPerms.getContextManager().unregisterCalculator((ContextCalculator)this.calculator);
            this.calculator = null;
        }
    }

    @Override
    public List<String> getGroups() {
        ArrayList<String> groups = new ArrayList<String>();
        for (Group group : this.luckPerms.getGroupManager().getLoadedGroups()) {
            groups.add(group.getName());
        }
        for (String string : super.getGroups()) {
            if (groups.contains(string)) continue;
            groups.add(string);
        }
        return groups;
    }

    @Override
    public boolean tryProvider(Essentials ess) {
        RegisteredServiceProvider provider = Bukkit.getServicesManager().getRegistration(LuckPerms.class);
        if (provider != null) {
            this.luckPerms = (LuckPerms)provider.getProvider();
            this.ess = ess;
        }
        return this.luckPerms != null && super.tryProvider(ess);
    }

    private final class CombinedCalculator
    implements ContextCalculator<Player> {
        private final Set<Calculator> calculators = new HashSet<Calculator>();

        private CombinedCalculator() {
        }

        public void calculate(Player target, ContextConsumer consumer) {
            if (!LuckPermsHandler.this.ess.getUsers().getAllUserUUIDs().contains(target.getUniqueId())) {
                return;
            }
            User user = LuckPermsHandler.this.ess.getUsers().loadUncachedUser(target.getUniqueId());
            if (user == null) {
                return;
            }
            for (Calculator calculator : this.calculators) {
                ((Iterable)calculator.function.apply(user)).forEach(value -> consumer.accept(calculator.id, value));
            }
        }

        public ContextSet estimatePotentialContexts() {
            ImmutableContextSet.Builder builder = ImmutableContextSet.builder();
            for (Calculator calculator : this.calculators) {
                ((Iterable)calculator.suggestions.get()).forEach(value -> builder.add(calculator.id, value));
            }
            return builder.build();
        }
    }

    private static final class Calculator {
        private final String id;
        private final Function<User, Iterable<String>> function;
        private final Supplier<Iterable<String>> suggestions;

        private Calculator(String id, Function<User, Iterable<String>> function, Supplier<Iterable<String>> suggestions) {
            this.id = id;
            this.function = function;
            this.suggestions = suggestions;
        }
    }
}

