/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.utils;

import com.earth2me.essentials.I18n;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.ess3.api.IEssentials;
import net.ess3.api.TranslatableException;

public final class DateUtil {
    private static final Pattern timePattern = Pattern.compile("(?:([0-9]+)\\s*y[a-z]*[,\\s]*)?(?:([0-9]+)\\s*mo[a-z]*[,\\s]*)?(?:([0-9]+)\\s*w[a-z]*[,\\s]*)?(?:([0-9]+)\\s*d[a-z]*[,\\s]*)?(?:([0-9]+)\\s*h[a-z]*[,\\s]*)?(?:([0-9]+)\\s*m[a-z]*[,\\s]*)?(?:([0-9]+)\\s*(?:s[a-z]*)?)?", 2);
    private static final int maxYears = 100000;

    private DateUtil() {
    }

    public static String removeTimePattern(String input) {
        return timePattern.matcher(input).replaceFirst("").trim();
    }

    public static long parseDateDiff(String time, boolean future) throws Exception {
        return DateUtil.parseDateDiff(time, future, false);
    }

    public static long parseDateDiff(String time, boolean future, boolean emptyEpoch) throws Exception {
        Matcher m = timePattern.matcher(time);
        int years = 0;
        int months = 0;
        int weeks = 0;
        int days = 0;
        int hours = 0;
        int minutes = 0;
        int seconds = 0;
        boolean found = false;
        while (m.find()) {
            if (m.group() == null || m.group().isEmpty()) continue;
            for (int i = 0; i < m.groupCount(); ++i) {
                if (m.group(i) == null || m.group(i).isEmpty()) continue;
                found = true;
                break;
            }
            if (!found) continue;
            if (m.group(1) != null && !m.group(1).isEmpty()) {
                years = Integer.parseInt(m.group(1));
            }
            if (m.group(2) != null && !m.group(2).isEmpty()) {
                months = Integer.parseInt(m.group(2));
            }
            if (m.group(3) != null && !m.group(3).isEmpty()) {
                weeks = Integer.parseInt(m.group(3));
            }
            if (m.group(4) != null && !m.group(4).isEmpty()) {
                days = Integer.parseInt(m.group(4));
            }
            if (m.group(5) != null && !m.group(5).isEmpty()) {
                hours = Integer.parseInt(m.group(5));
            }
            if (m.group(6) != null && !m.group(6).isEmpty()) {
                minutes = Integer.parseInt(m.group(6));
            }
            if (m.group(7) == null || m.group(7).isEmpty()) break;
            seconds = Integer.parseInt(m.group(7));
            break;
        }
        if (!found) {
            throw new TranslatableException("illegalDate", new Object[0]);
        }
        GregorianCalendar c = new GregorianCalendar();
        if (emptyEpoch) {
            c.setTimeInMillis(0L);
        }
        if (years > 0) {
            if (years > 100000) {
                years = 100000;
            }
            ((Calendar)c).add(1, years * (future ? 1 : -1));
        }
        if (months > 0) {
            ((Calendar)c).add(2, months * (future ? 1 : -1));
        }
        if (weeks > 0) {
            ((Calendar)c).add(3, weeks * (future ? 1 : -1));
        }
        if (days > 0) {
            ((Calendar)c).add(5, days * (future ? 1 : -1));
        }
        if (hours > 0) {
            ((Calendar)c).add(11, hours * (future ? 1 : -1));
        }
        if (minutes > 0) {
            ((Calendar)c).add(12, minutes * (future ? 1 : -1));
        }
        if (seconds > 0) {
            ((Calendar)c).add(13, seconds * (future ? 1 : -1));
        }
        GregorianCalendar max = new GregorianCalendar();
        ((Calendar)max).add(1, 10);
        if (c.after(max)) {
            return max.getTimeInMillis();
        }
        return c.getTimeInMillis();
    }

    static int dateDiff(int type, Calendar fromDate, Calendar toDate, boolean future) {
        int toYear;
        boolean year = true;
        int fromYear = fromDate.get(1);
        if (Math.abs(fromYear - (toYear = toDate.get(1))) > 100000) {
            toDate.set(1, fromYear + (future ? 100000 : -100000));
        }
        int diff = 0;
        long savedDate = fromDate.getTimeInMillis();
        while (future && !fromDate.after(toDate) || !future && !fromDate.before(toDate)) {
            savedDate = fromDate.getTimeInMillis();
            fromDate.add(type, future ? 1 : -1);
            ++diff;
        }
        fromDate.setTimeInMillis(savedDate);
        return --diff;
    }

    public static String formatDateDiff(long date) {
        GregorianCalendar c = new GregorianCalendar();
        c.setTimeInMillis(date);
        GregorianCalendar now = new GregorianCalendar();
        return DateUtil.formatDateDiff(now, c);
    }

    public static String formatDateDiff(Calendar fromDate, Calendar toDate) {
        boolean future = false;
        if (toDate.equals(fromDate)) {
            return I18n.tlLiteral("now", new Object[0]);
        }
        if (toDate.after(fromDate)) {
            future = true;
        }
        toDate.add(14, future ? 50 : -50);
        StringBuilder sb = new StringBuilder();
        int[] types = new int[]{1, 2, 5, 11, 12, 13};
        String[] names = new String[]{I18n.tlLiteral("year", new Object[0]), I18n.tlLiteral("years", new Object[0]), I18n.tlLiteral("month", new Object[0]), I18n.tlLiteral("months", new Object[0]), I18n.tlLiteral("day", new Object[0]), I18n.tlLiteral("days", new Object[0]), I18n.tlLiteral("hour", new Object[0]), I18n.tlLiteral("hours", new Object[0]), I18n.tlLiteral("minute", new Object[0]), I18n.tlLiteral("minutes", new Object[0]), I18n.tlLiteral("second", new Object[0]), I18n.tlLiteral("seconds", new Object[0])};
        int accuracy = 0;
        for (int i = 0; i < types.length && accuracy <= 2; ++i) {
            int diff = DateUtil.dateDiff(types[i], fromDate, toDate, future);
            if (diff <= 0) continue;
            ++accuracy;
            sb.append(" ").append(diff).append(" ").append(names[i * 2 + (diff > 1 ? 1 : 0)]);
        }
        toDate.add(14, future ? -50 : 50);
        if (sb.length() == 0) {
            return I18n.tlLiteral("now", new Object[0]);
        }
        return sb.toString().trim();
    }

    public static String formatDate(long date, IEssentials ess) {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTimeInMillis(date);
        DateFormat df = DateFormat.getDateTimeInstance(1, 1, ess.getI18n().getCurrentLocale());
        return df.format(gc.getTime());
    }
}

