/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.utils;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.lang.reflect.Field;
import java.util.ArrayList;

public final class RegistryUtil {
    private static final Table<Class<?>, String, Object> registryCache = HashBasedTable.create();

    private RegistryUtil() {
    }

    public static <T> Object[] values(Class<T> registry) {
        if (registry.getEnumConstants() != null) {
            return registry.getEnumConstants();
        }
        Object[] values = (Object[])registryCache.get(registry, (Object)"$values");
        if (values != null) {
            return values;
        }
        ArrayList<Object> set = new ArrayList<Object>();
        for (Field field : registry.getDeclaredFields()) {
            try {
                Object value = field.get(null);
                if (value == null || !registry.isAssignableFrom(value.getClass())) continue;
                set.add(value);
            }
            catch (IllegalAccessException | NullPointerException exception) {
                // empty catch block
            }
        }
        Object[] array = new Object[set.size()];
        for (int i = 0; i < set.size(); ++i) {
            array[i] = set.get(i);
        }
        registryCache.put(registry, (Object)"$values", (Object)array);
        return array;
    }

    public static <T> T valueOf(Class<T> registry, String ... names) {
        for (String name : names) {
            Object value = registryCache.get(registry, (Object)name);
            if (value != null) {
                return (T)value;
            }
            try {
                value = registry.getDeclaredField(name).get(null);
                if (value == null) continue;
                registryCache.put(registry, (Object)name, value);
                return (T)value;
            }
            catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
                // empty catch block
            }
        }
        return null;
    }
}

