/*
 * Decompiled with CFR 0.152.
 */
package net.ess3.nms.refl.providers;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.ess3.nms.refl.ReflUtil;
import net.ess3.provider.FormattedCommandAliasProvider;
import net.essentialsx.providers.ProviderData;
import org.bukkit.command.CommandSender;
import org.bukkit.command.FormattedCommandAlias;

@ProviderData(description="Reflection Formatted Command Alias Provider")
public class ReflFormattedCommandAliasProvider
implements FormattedCommandAliasProvider {
    private final boolean senderArg;
    private final Field formatStringsField;
    private final MethodHandle buildCommandMethodHandle;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReflFormattedCommandAliasProvider() {
        boolean senderArg = true;
        Field formatStringsField = null;
        MethodHandle buildCommandMethodHandle = null;
        try {
            Class<FormattedCommandAlias> formattedCommandAliasClass = FormattedCommandAlias.class;
            formatStringsField = ReflUtil.getFieldCached(formattedCommandAliasClass, "formatStrings");
            Method buildCommandMethod = ReflUtil.getMethodCached(formattedCommandAliasClass, "buildCommand", CommandSender.class, String.class, String[].class);
            if (buildCommandMethod == null) {
                senderArg = false;
                buildCommandMethod = ReflUtil.getMethodCached(formattedCommandAliasClass, "buildCommand", String.class, String[].class);
            }
            if (buildCommandMethod == null) {
                throw new NoSuchMethodException("Could not find buildCommand method in FormattedCommandAlias");
            }
            buildCommandMethod.setAccessible(true);
            buildCommandMethodHandle = MethodHandles.lookup().unreflect(buildCommandMethod);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            this.formatStringsField = formatStringsField;
            this.buildCommandMethodHandle = buildCommandMethodHandle;
            this.senderArg = senderArg;
        }
    }

    @Override
    public List<String> createCommands(FormattedCommandAlias command, CommandSender sender, String[] args) {
        ArrayList<String> commands = new ArrayList<String>();
        for (String formatString : this.getFormatStrings(command)) {
            String cmd;
            try {
                cmd = this.buildCommand(command, sender, formatString, args);
            }
            catch (Throwable th) {
                continue;
            }
            if (cmd == null) continue;
            commands.add(cmd.trim());
        }
        return commands;
    }

    @Override
    public String[] getFormatStrings(FormattedCommandAlias command) {
        try {
            return (String[])this.formatStringsField.get(command);
        }
        catch (ReflectiveOperationException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public String buildCommand(FormattedCommandAlias command, CommandSender sender, String formatString, String[] args) {
        try {
            if (this.senderArg) {
                return this.buildCommandMethodHandle.invoke(command, sender, formatString, args);
            }
            return this.buildCommandMethodHandle.invoke(command, formatString, args);
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }
}

