/*
 * Decompiled with CFR 0.152.
 */
package de.myzelyam.supervanish;

import de.myzelyam.supervanish.SuperVanish;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class VanishPlayer {
    private final SuperVanish plugin;
    private final UUID playerUUID;
    private boolean itemPickUps;
    private int seePermissionLevel;
    private int usePermissionLevel;

    VanishPlayer(Player player, SuperVanish plugin, boolean itemPickUps) {
        this.plugin = plugin;
        this.playerUUID = player.getUniqueId();
        this.itemPickUps = itemPickUps;
        if (plugin.getSettings().getBoolean("IndicationFeatures.LayeredPermissions.LayeredSeeAndUsePermissions", false)) {
            this.seePermissionLevel = plugin.getLayeredPermissionLevel((CommandSender)player, "see");
            this.usePermissionLevel = plugin.getLayeredPermissionLevel((CommandSender)player, "use");
        }
    }

    public boolean isOnlineVanished() {
        return this.plugin.getVanishStateMgr().isVanished(this.playerUUID);
    }

    public boolean hasItemPickUpsEnabled() {
        return this.itemPickUps;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VanishPlayer that = (VanishPlayer)o;
        return Objects.equals(this.playerUUID, that.playerUUID);
    }

    public int hashCode() {
        return Objects.hash(this.playerUUID);
    }

    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    public void setItemPickUps(boolean itemPickUps) {
        this.itemPickUps = itemPickUps;
    }

    public int getSeePermissionLevel() {
        return this.seePermissionLevel;
    }

    public int getUsePermissionLevel() {
        return this.usePermissionLevel;
    }
}

