/*
 * Decompiled with CFR 0.152.
 */
package de.myzelyam.supervanish.commands;

import de.myzelyam.supervanish.SuperVanish;
import de.myzelyam.supervanish.commands.CommandAction;
import de.myzelyam.supervanish.commands.Executable;
import java.util.Collection;
import java.util.UUID;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public abstract class SubCommand
implements Executable {
    protected final SuperVanish plugin;

    public SubCommand(SuperVanish plugin) {
        this.plugin = plugin;
    }

    protected Collection<UUID> getAllVanishedPlayers() {
        return this.plugin.getVanishStateMgr().getVanishedPlayers();
    }

    protected Collection<UUID> getOnlineVanishedPlayers() {
        return this.plugin.getVanishStateMgr().getOnlineVanishedPlayers();
    }

    public void hidePlayer(Player player) {
        this.plugin.getVisibilityChanger().hidePlayer(player);
    }

    public void showPlayer(Player player) {
        this.plugin.getVisibilityChanger().showPlayer(player);
    }

    public boolean isVanished(UUID uuid) {
        return this.plugin.getVanishStateMgr().isVanished(uuid);
    }

    public boolean canDo(CommandSender sender, CommandAction action, boolean sendErrors) {
        if (!(sender instanceof Player) && !action.usableByConsole()) {
            if (sendErrors) {
                this.plugin.sendMessage(sender, "InvalidSender", sender);
            }
            return false;
        }
        if (!action.checkPermission(sender, this.plugin)) {
            if (sendErrors) {
                this.plugin.sendMessage(sender, "NoPermission", sender);
            }
            return false;
        }
        return true;
    }
}

