/*
 * Decompiled with CFR 0.152.
 */
package de.myzelyam.supervanish.commands.subcommands;

import de.myzelyam.supervanish.SuperVanish;
import de.myzelyam.supervanish.commands.CommandAction;
import de.myzelyam.supervanish.commands.SubCommand;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class VanishSelf
extends SubCommand {
    public VanishSelf(SuperVanish plugin) {
        super(plugin);
    }

    @Override
    public void execute(Command cmd, CommandSender s, String[] args, String label) {
        if (this.canDo(s, CommandAction.VANISH_SELF, true)) {
            Player p = (Player)s;
            if (args.length == 0) {
                if (this.isVanished(p.getUniqueId())) {
                    this.showPlayer(p);
                } else {
                    this.hidePlayer(p);
                }
            } else if (args.length == 1) {
                if (args[0].equalsIgnoreCase("off") || args[0].equalsIgnoreCase("reappear") || args[0].equalsIgnoreCase("disable")) {
                    if (!this.isVanished(p.getUniqueId())) {
                        this.plugin.sendMessage((CommandSender)p, "NotVanishedError", p);
                        return;
                    }
                    this.showPlayer(p);
                } else if (args[0].equalsIgnoreCase("-s")) {
                    if (this.isVanished(p.getUniqueId())) {
                        this.plugin.getVisibilityChanger().showPlayer(p, null, true);
                    } else {
                        this.plugin.getVisibilityChanger().hidePlayer(p, null, true);
                    }
                } else {
                    if (this.isVanished(p.getUniqueId())) {
                        this.plugin.sendMessage((CommandSender)p, "AlreadyVanishedError", p);
                        return;
                    }
                    this.hidePlayer(p);
                }
            }
        }
    }
}

