/*
 * Decompiled with CFR 0.152.
 */
package de.myzelyam.supervanish.config;

import de.myzelyam.supervanish.SuperVanish;
import de.myzelyam.supervanish.config.PluginFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigurableFile
implements PluginFile<FileConfiguration> {
    private final SuperVanish plugin;
    private String name;
    private File file;
    private FileConfiguration fileConfiguration;
    private FileConfiguration defaultFileConfiguration;

    public ConfigurableFile(String name, SuperVanish plugin) {
        this.name = name + ".yml";
        this.plugin = plugin;
        this.setup();
    }

    @Override
    public String getName() {
        return this.name;
    }

    private void setup() {
        this.file = new File(this.plugin.getDataFolder(), this.name);
        try (InputStreamReader reader = new InputStreamReader(this.plugin.getResource(this.name));){
            this.defaultFileConfiguration = YamlConfiguration.loadConfiguration((Reader)reader);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.save();
    }

    @Override
    public void reload() {
        this.fileConfiguration = YamlConfiguration.loadConfiguration((File)this.file);
    }

    @Override
    public FileConfiguration getConfig() {
        if (this.fileConfiguration == null) {
            this.reload();
        }
        return this.fileConfiguration;
    }

    @Override
    public void save() {
        if (!this.file.exists()) {
            this.plugin.saveResource(this.name, false);
        }
    }

    public FileConfiguration getDefaultConfig() {
        return this.defaultFileConfiguration;
    }
}

