/*
 * Decompiled with CFR 0.152.
 */
package de.myzelyam.supervanish.features;

import de.myzelyam.api.vanish.PlayerHideEvent;
import de.myzelyam.api.vanish.PlayerShowEvent;
import de.myzelyam.supervanish.SuperVanish;
import de.myzelyam.supervanish.features.Feature;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class NightVision
extends Feature
implements Runnable {
    public static final int INFINITE_POTION_EFFECT_LENGTH = Short.MAX_VALUE;
    private final Map<UUID, PotionEffect> playerPreviousPotionEffectMap = new HashMap<UUID, PotionEffect>();

    public NightVision(SuperVanish plugin) {
        super(plugin);
    }

    @Override
    public void onEnable() {
        this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)this, 2400L, 2400L);
    }

    @Override
    public boolean isActive() {
        return this.plugin.getSettings().getBoolean("InvisibilityFeatures.NightVisionEffect");
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onVanish(PlayerHideEvent e) {
        Player p = e.getPlayer();
        if (this.plugin.getVersionUtil().isOneDotXOrHigher(10) && p.getPotionEffect(PotionEffectType.NIGHT_VISION) != null) {
            this.playerPreviousPotionEffectMap.put(p.getUniqueId(), p.getPotionEffect(PotionEffectType.NIGHT_VISION));
        }
        this.sendAddPotionEffect(p);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onReappear(PlayerShowEvent e) {
        Player p = e.getPlayer();
        this.sendRemovePotionEffect(p);
        if (this.playerPreviousPotionEffectMap.containsKey(p.getUniqueId())) {
            p.addPotionEffect(this.playerPreviousPotionEffectMap.remove(p.getUniqueId()));
        }
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent e) {
        Player p = e.getPlayer();
        if (!this.plugin.getVanishStateMgr().isVanished(p.getUniqueId())) {
            if (this.playerPreviousPotionEffectMap.containsKey(p.getUniqueId())) {
                p.addPotionEffect(this.playerPreviousPotionEffectMap.remove(p.getUniqueId()));
            }
        } else {
            this.sendAddPotionEffect(p);
        }
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent e) {
        Player p = e.getPlayer();
        if (!this.plugin.getVanishStateMgr().isVanished(p.getUniqueId())) {
            return;
        }
        this.sendRemovePotionEffect(p);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onTeleport(PlayerTeleportEvent e) {
        Player p = e.getPlayer();
        if (!this.plugin.getVanishStateMgr().isVanished(p.getUniqueId())) {
            return;
        }
        if (e.getFrom().getWorld() == null || e.getTo() == null || e.getTo().getWorld() == null || e.getFrom().getWorld().getName().equals(e.getTo().getWorld().getName())) {
            return;
        }
        this.sendRemovePotionEffect(p);
    }

    @EventHandler
    public void onWorldChange(PlayerChangedWorldEvent e) {
        Player p = e.getPlayer();
        if (!this.plugin.getVanishStateMgr().isVanished(p.getUniqueId())) {
            return;
        }
        this.sendAddPotionEffect(p);
    }

    @Override
    public void run() {
        for (UUID uuid : this.plugin.getVanishStateMgr().getOnlineVanishedPlayers()) {
            Player p = Bukkit.getPlayer((UUID)uuid);
            if (p == null) continue;
            this.sendRemovePotionEffect(p);
            this.sendAddPotionEffect(p);
        }
    }

    private void sendAddPotionEffect(Player p) {
        p.addPotionEffect(new PotionEffect(PotionEffectType.NIGHT_VISION, Short.MAX_VALUE, 0, true, false));
    }

    private void sendRemovePotionEffect(Player p) {
        p.removePotionEffect(PotionEffectType.NIGHT_VISION);
    }
}

