/*
 * Decompiled with CFR 0.152.
 */
package de.myzelyam.supervanish.features;

import com.destroystokyo.paper.event.entity.PlayerNaturallySpawnCreaturesEvent;
import com.destroystokyo.paper.event.entity.PreSpawnerSpawnEvent;
import com.destroystokyo.paper.event.entity.SkeletonHorseTrapEvent;
import de.myzelyam.supervanish.SuperVanish;
import de.myzelyam.supervanish.features.Feature;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;

public class NoMobSpawn
extends Feature {
    private boolean suppressErrors = false;

    public NoMobSpawn(SuperVanish plugin) {
        super(plugin);
    }

    @EventHandler
    public void onSkeletonHorseTrap(SkeletonHorseTrapEvent e) {
        block4: {
            try {
                List humans = e.getEligibleHumans();
                int humansCount = humans.size();
                for (HumanEntity human : humans) {
                    if (!(human instanceof Player)) continue;
                    Player p = (Player)human;
                    if (!this.plugin.getVanishStateMgr().isVanished(p.getUniqueId())) continue;
                    --humansCount;
                }
                if (humansCount == 0) {
                    e.setCancelled(true);
                }
            }
            catch (Exception er) {
                if (this.suppressErrors) break block4;
                this.plugin.logException(er);
                this.suppressErrors = true;
            }
        }
    }

    @EventHandler
    public void onEntitySpawn(PlayerNaturallySpawnCreaturesEvent e) {
        block3: {
            try {
                if (this.plugin.getVanishStateMgr().isVanished(e.getPlayer().getUniqueId())) {
                    e.setCancelled(true);
                }
            }
            catch (Exception er) {
                if (this.suppressErrors) break block3;
                this.plugin.logException(er);
                this.suppressErrors = true;
            }
        }
    }

    @EventHandler
    public void onEntitySpawnerSpawn(PreSpawnerSpawnEvent e) {
        block5: {
            try {
                boolean vanishedPlayerInRange = false;
                for (UUID vanishedUUID : this.plugin.getVanishStateMgr().getOnlineVanishedPlayers()) {
                    Player p = Bukkit.getPlayer((UUID)vanishedUUID);
                    if (p == null || !p.getWorld().equals((Object)e.getSpawnerLocation().getWorld()) || !(p.getLocation().distanceSquared(e.getSpawnerLocation()) <= 256.0) || p.getGameMode() == GameMode.SPECTATOR) continue;
                    vanishedPlayerInRange = true;
                }
                if (!vanishedPlayerInRange) {
                    return;
                }
                for (Player p : Bukkit.getOnlinePlayers()) {
                    if (!p.getWorld().equals((Object)e.getSpawnerLocation().getWorld()) || !(p.getLocation().distanceSquared(e.getSpawnerLocation()) <= 256.0) || p.getGameMode() == GameMode.SPECTATOR || this.plugin.getVanishStateMgr().isVanished(p.getUniqueId())) continue;
                    return;
                }
                e.setCancelled(true);
            }
            catch (Exception er) {
                if (this.suppressErrors) break block5;
                this.plugin.logException(er);
                this.suppressErrors = true;
            }
        }
    }

    @Override
    public boolean isActive() {
        return this.plugin.getSettings().getBoolean("InvisibilityFeatures.PreventMobSpawning", true);
    }
}

