/*
 * Decompiled with CFR 0.152.
 */
package de.myzelyam.supervanish.features;

import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketListener;
import de.myzelyam.api.vanish.PlayerShowEvent;
import de.myzelyam.supervanish.SuperVanish;
import de.myzelyam.supervanish.features.Feature;
import de.myzelyam.supervanish.features.SilentOpenChestPacketAdapter;
import de.myzelyam.supervanish.hooks.OpenInvHook;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class SilentOpenChest
extends Feature {
    private final Map<Player, StateInfo> playerStateInfoMap = new HashMap<Player, StateInfo>();
    private final Collection<Material> additionalChestMaterials = new ArrayList<Material>();

    public SilentOpenChest(SuperVanish plugin) {
        super(plugin);
        if (plugin.getVersionUtil().isOneDotXOrHigher(11)) {
            try {
                InventoryType testInvType = InventoryType.SHULKER_BOX;
                this.additionalChestMaterials.addAll(Arrays.asList(Material.BLACK_SHULKER_BOX, Material.BLUE_SHULKER_BOX, Material.BROWN_SHULKER_BOX, Material.CYAN_SHULKER_BOX, Material.GRAY_SHULKER_BOX, Material.GREEN_SHULKER_BOX, Material.LIGHT_BLUE_SHULKER_BOX, Material.LIME_SHULKER_BOX, Material.MAGENTA_SHULKER_BOX, Material.ORANGE_SHULKER_BOX, Material.PINK_SHULKER_BOX, Material.PURPLE_SHULKER_BOX, Material.RED_SHULKER_BOX, Material.WHITE_SHULKER_BOX, Material.YELLOW_SHULKER_BOX));
                try {
                    this.additionalChestMaterials.add(Material.LIGHT_GRAY_SHULKER_BOX);
                }
                catch (NoSuchFieldError e) {
                    this.additionalChestMaterials.add(Material.valueOf((String)"SILVER_SHULKER_BOX"));
                }
                try {
                    this.additionalChestMaterials.add(Material.SHULKER_BOX);
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                if (plugin.getVersionUtil().isOneDotXOrHigher(14)) {
                    this.additionalChestMaterials.add(Material.valueOf((String)"BARREL"));
                }
            }
            catch (IllegalArgumentException | NoSuchFieldError throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public void onDisable() {
        for (Player p : this.playerStateInfoMap.keySet()) {
            StateInfo stateInfo = this.playerStateInfoMap.remove(p);
            if (stateInfo == null) continue;
            this.restoreState(stateInfo, p);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onSpectatorClick(InventoryClickEvent e) {
        if (!(e.getWhoClicked() instanceof Player)) {
            return;
        }
        Player p = (Player)e.getWhoClicked();
        if (!this.plugin.getVanishStateMgr().isVanished(p.getUniqueId())) {
            return;
        }
        if (!this.playerStateInfoMap.containsKey(p)) {
            return;
        }
        if (p.getGameMode() == GameMode.SPECTATOR) {
            e.setCancelled(false);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onQuit(PlayerQuitEvent e) {
        Player p = e.getPlayer();
        StateInfo stateInfo = this.playerStateInfoMap.remove(p);
        if (stateInfo == null) {
            return;
        }
        this.restoreState(stateInfo, p);
        this.playerStateInfoMap.remove(p);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onTeleport(PlayerTeleportEvent e) {
        Player p = e.getPlayer();
        if (this.playerStateInfoMap.containsKey(p) && e.getCause() == PlayerTeleportEvent.TeleportCause.SPECTATE) {
            e.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onReappear(PlayerShowEvent e) {
        Player p = e.getPlayer();
        StateInfo stateInfo = this.playerStateInfoMap.remove(p);
        if (stateInfo == null) {
            return;
        }
        p.closeInventory();
        this.restoreState(stateInfo, p);
        this.playerStateInfoMap.remove(p);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onMove(PlayerMoveEvent e) {
        Player p = e.getPlayer();
        if (this.playerStateInfoMap.containsKey(p)) {
            Location loc;
            Location location = loc = e.getTo() != null ? e.getTo() : e.getFrom();
            if (this.playerStateInfoMap.get((Object)p).openLoc.distance(loc) > 0.5) {
                p.closeInventory();
                this.restoreState(this.playerStateInfoMap.get(p), p);
                this.playerStateInfoMap.remove(p);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onGameModeChange(PlayerGameModeChangeEvent e) {
        Player p = e.getPlayer();
        if (this.playerStateInfoMap.containsKey(p) && e.getNewGameMode() != GameMode.SPECTATOR && e.isCancelled()) {
            e.setCancelled(false);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onChestInteract(PlayerInteractEvent e) {
        Player p = e.getPlayer();
        if (!this.plugin.getVanishStateMgr().isVanished(p.getUniqueId()) || !p.hasPermission("sv.silentchest")) {
            return;
        }
        if (e.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (p.getGameMode() == GameMode.SPECTATOR) {
            return;
        }
        if (p.isSneaking() && p.getItemInHand() != null && (p.getItemInHand().getType().isBlock() || p.getItemInHand().getType() == Material.ITEM_FRAME) && p.getItemInHand().getType() != Material.AIR) {
            return;
        }
        Block block = e.getClickedBlock();
        if (block == null) {
            return;
        }
        if (block.getType() == Material.ENDER_CHEST) {
            e.setCancelled(true);
            p.openInventory(p.getEnderChest());
            return;
        }
        if (!(block.getType() == Material.CHEST || block.getType() == Material.TRAPPED_CHEST || this.plugin.getVersionUtil().isOneDotXOrHigher(11) && this.additionalChestMaterials.contains(block.getType()))) {
            return;
        }
        StateInfo stateInfo = StateInfo.extract(p);
        p.setVelocity(new Vector(0, 0, 0));
        this.playerStateInfoMap.put(p, stateInfo);
        p.setGameMode(GameMode.SPECTATOR);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onChestClose(InventoryCloseEvent e) {
        if (!(e.getPlayer() instanceof Player)) {
            return;
        }
        final Player p = (Player)e.getPlayer();
        if (!this.playerStateInfoMap.containsKey(p)) {
            return;
        }
        new BukkitRunnable(this){
            final /* synthetic */ SilentOpenChest this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                StateInfo stateInfo = this.this$0.playerStateInfoMap.get(p);
                if (stateInfo == null) {
                    return;
                }
                this.this$0.restoreState(stateInfo, p);
                this.this$0.playerStateInfoMap.remove(p);
            }
        }.runTaskLater((Plugin)this.plugin, 1L);
    }

    private void restoreState(final StateInfo stateInfo, final Player p) {
        p.setGameMode(stateInfo.gameMode);
        p.teleport(p.getLocation().add(0.0, 0.2, 0.0));
        new BukkitRunnable(this){
            final /* synthetic */ SilentOpenChest this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                p.setAllowFlight(stateInfo.canFly);
                p.setFlying(stateInfo.isFlying);
            }
        }.runTaskLater((Plugin)this.plugin, 1L);
    }

    @Override
    public boolean isActive() {
        return this.plugin.getSettings().getBoolean("InvisibilityFeatures.OpenChestsSilently") && (this.plugin.getPluginHookMgr() == null || !this.plugin.getPluginHookMgr().isHookActive(OpenInvHook.class));
    }

    private boolean isShulkerBox(Inventory inv) {
        try {
            return inv.getType() == InventoryType.SHULKER_BOX;
        }
        catch (NoSuchFieldError e) {
            return false;
        }
    }

    private boolean isShulkerBox(InventoryView inv) {
        try {
            return inv.getType() == InventoryType.SHULKER_BOX;
        }
        catch (NoSuchFieldError e) {
            return false;
        }
    }

    public boolean hasSilentlyOpenedChest(Player p) {
        return this.playerStateInfoMap.containsKey(p);
    }

    @Override
    public void onEnable() {
        if (!this.plugin.getVersionUtil().isOneDotXOrHigher(19)) {
            SilentOpenChestPacketAdapter packetAdapter = new SilentOpenChestPacketAdapter(this);
            ProtocolLibrary.getProtocolManager().addPacketListener((PacketListener)packetAdapter);
        }
    }

    private static class StateInfo {
        private final boolean canFly;
        private final boolean isFlying;
        private final GameMode gameMode;
        private final Location openLoc;

        StateInfo(boolean canFly, boolean isFlying, GameMode gameMode, Location openLoc) {
            this.canFly = canFly;
            this.isFlying = isFlying;
            this.gameMode = gameMode;
            this.openLoc = openLoc;
        }

        static StateInfo extract(Player p) {
            return new StateInfo(p.getAllowFlight(), p.isFlying(), p.getGameMode(), p.getLocation());
        }
    }
}

