/*
 * Decompiled with CFR 0.152.
 */
package de.myzelyam.supervanish.features;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.reflect.FieldAccessException;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.PlayerInfoData;
import com.google.common.collect.ImmutableList;
import de.myzelyam.supervanish.features.SilentOpenChest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class SilentOpenChestPacketAdapter
extends PacketAdapter {
    private final SilentOpenChest silentOpenChest;
    private boolean suppressErrors = false;

    public SilentOpenChestPacketAdapter(SilentOpenChest silentOpenChest) {
        super((Plugin)silentOpenChest.plugin, ListenerPriority.LOW, new PacketType[]{PacketType.Play.Server.PLAYER_INFO, PacketType.Play.Server.ABILITIES, PacketType.Play.Server.ENTITY_METADATA});
        this.silentOpenChest = silentOpenChest;
    }

    public void onPacketSending(PacketEvent event) {
        block18: {
            try {
                int entityID;
                Player receiver = event.getPlayer();
                if (receiver == null) {
                    return;
                }
                if (event.getPacketType() == PacketType.Play.Server.PLAYER_INFO) {
                    event.setPacket(event.getPacket().shallowClone());
                    ArrayList<PlayerInfoData> infoDataList = new ArrayList<PlayerInfoData>((Collection)event.getPacket().getPlayerInfoDataLists().read(0));
                    for (PlayerInfoData infoData : ImmutableList.copyOf(infoDataList)) {
                        int latency;
                        if (this.silentOpenChest.plugin.getVisibilityChanger().getHider().isHidden(infoData.getProfile().getUUID(), receiver) || !this.silentOpenChest.plugin.getVanishStateMgr().isVanished(infoData.getProfile().getUUID())) continue;
                        Player vanishedTabPlayer = Bukkit.getPlayer((UUID)infoData.getProfile().getUUID());
                        if (infoData.getGameMode() != EnumWrappers.NativeGameMode.SPECTATOR || !this.silentOpenChest.hasSilentlyOpenedChest(vanishedTabPlayer) || event.getPacket().getPlayerInfoAction().read(0) != EnumWrappers.PlayerInfoAction.UPDATE_GAME_MODE) continue;
                        try {
                            latency = infoData.getLatency();
                        }
                        catch (NoSuchMethodError e) {
                            latency = 21;
                        }
                        PlayerInfoData newData = new PlayerInfoData(infoData.getProfile(), latency, EnumWrappers.NativeGameMode.SURVIVAL, infoData.getDisplayName());
                        infoDataList.remove(infoData);
                        infoDataList.add(newData);
                    }
                    event.getPacket().getPlayerInfoDataLists().write(0, infoDataList);
                    break block18;
                }
                if (event.getPacketType() == PacketType.Play.Server.GAME_STATE_CHANGE) {
                    if (!this.silentOpenChest.plugin.getVanishStateMgr().isVanished(receiver.getUniqueId())) break block18;
                    try {
                        if ((Integer)event.getPacket().getIntegers().read(0) != 3) {
                            return;
                        }
                    }
                    catch (FieldAccessException infoDataList) {
                        // empty catch block
                    }
                    if (!this.silentOpenChest.hasSilentlyOpenedChest(receiver)) {
                        return;
                    }
                    event.setCancelled(true);
                    break block18;
                }
                if (event.getPacketType() == PacketType.Play.Server.ABILITIES) {
                    if (this.silentOpenChest.plugin.getVanishStateMgr().isVanished(receiver.getUniqueId())) {
                        if (!this.silentOpenChest.hasSilentlyOpenedChest(receiver)) {
                            return;
                        }
                        event.setCancelled(true);
                    }
                } else if (event.getPacketType() == PacketType.Play.Server.ENTITY_METADATA && (entityID = ((Integer)event.getPacket().getIntegers().read(0)).intValue()) == receiver.getEntityId() && this.silentOpenChest.plugin.getVanishStateMgr().isVanished(receiver.getUniqueId())) {
                    if (!this.silentOpenChest.hasSilentlyOpenedChest(receiver)) {
                        return;
                    }
                    event.setCancelled(true);
                }
            }
            catch (Exception | NoClassDefFoundError e) {
                if (this.suppressErrors || e.getMessage() != null && e.getMessage().endsWith("is not supported for temporary players.")) break block18;
                this.silentOpenChest.plugin.logException(e);
                this.silentOpenChest.plugin.getLogger().warning("IMPORTANT: Please make sure that you are using the latest dev-build of ProtocolLib and that your server is up-to-date! This error likely happened inside of ProtocolLib code which is out of SuperVanish's control. It's part of an optional feature module and can be removed safely by disabling OpenChestsSilently in the config file. Please report this error if you can reproduce it on an up-to-date server with only latest ProtocolLib and latest SV installed.");
                this.suppressErrors = true;
            }
        }
    }
}

