/*
 * Decompiled with CFR 0.152.
 */
package de.myzelyam.supervanish.features;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.PlayerInfoData;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import com.comphenix.protocol.wrappers.WrappedGameProfile;
import com.google.common.collect.ImmutableList;
import de.myzelyam.api.vanish.PlayerShowEvent;
import de.myzelyam.api.vanish.PostPlayerHideEvent;
import de.myzelyam.supervanish.SuperVanish;
import de.myzelyam.supervanish.features.Feature;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;

public class VanishIndication
extends Feature {
    private boolean suppressErrors = false;

    public VanishIndication(SuperVanish plugin) {
        super(plugin);
    }

    @Override
    public boolean isActive() {
        return !this.plugin.getVersionUtil().isOneDotXOrHigher(19) && this.plugin.getSettings().getBoolean("IndicationFeatures.MarkVanishedPlayersAsSpectators");
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onVanish(PostPlayerHideEvent e) {
        Player p = e.getPlayer();
        for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
            if (this.plugin.getVisibilityChanger().getHider().isHidden(p, onlinePlayer) || p == onlinePlayer) continue;
            this.sendPlayerInfoChangeGameModePacket(onlinePlayer, p, true);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onReappear(PlayerShowEvent e) {
        Player p = e.getPlayer();
        for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
            if (this.plugin.getVisibilityChanger().getHider().isHidden(p, onlinePlayer) || p == onlinePlayer) continue;
            this.delay(() -> this.sendPlayerInfoChangeGameModePacket(onlinePlayer, p, false));
        }
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent e) {
        Player p = e.getPlayer();
        this.delay(() -> {
            if (this.plugin.getVanishStateMgr().isVanished(p.getUniqueId())) {
                for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                    if (this.plugin.getVisibilityChanger().getHider().isHidden(p, onlinePlayer) || p == onlinePlayer) continue;
                    this.sendPlayerInfoChangeGameModePacket(onlinePlayer, p, true);
                }
            }
            for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                if (!this.plugin.getVanishStateMgr().isVanished(onlinePlayer.getUniqueId()) || this.plugin.getVisibilityChanger().getHider().isHidden(onlinePlayer, p) || p == onlinePlayer) continue;
                this.sendPlayerInfoChangeGameModePacket(p, onlinePlayer, true);
            }
        });
    }

    @Override
    public void onEnable() {
        ProtocolLibrary.getProtocolManager().addPacketListener((PacketListener)new PacketAdapter((Plugin)this.plugin, ListenerPriority.NORMAL, new PacketType[]{PacketType.Play.Server.PLAYER_INFO}){

            public void onPacketSending(PacketEvent event) {
                block7: {
                    try {
                        event.setPacket(event.getPacket().shallowClone());
                        ArrayList<PlayerInfoData> infoDataList = new ArrayList<PlayerInfoData>((Collection)event.getPacket().getPlayerInfoDataLists().read(0));
                        Player receiver = event.getPlayer();
                        for (PlayerInfoData infoData : ImmutableList.copyOf(infoDataList)) {
                            try {
                                int latency;
                                if (VanishIndication.this.plugin.getVisibilityChanger().getHider().isHidden(infoData.getProfile().getUUID(), receiver) || !VanishIndication.this.plugin.getVanishStateMgr().isVanished(infoData.getProfile().getUUID()) || receiver.getUniqueId().equals(infoData.getProfile().getUUID()) || infoData.getGameMode() == EnumWrappers.NativeGameMode.SPECTATOR) continue;
                                try {
                                    latency = infoData.getLatency();
                                }
                                catch (NoSuchMethodError e) {
                                    latency = 21;
                                }
                                if (event.getPacket().getPlayerInfoAction().read(0) != EnumWrappers.PlayerInfoAction.UPDATE_GAME_MODE) continue;
                                PlayerInfoData newData = new PlayerInfoData(infoData.getProfile(), latency, EnumWrappers.NativeGameMode.SPECTATOR, infoData.getDisplayName());
                                infoDataList.remove(infoData);
                                infoDataList.add(newData);
                            }
                            catch (UnsupportedOperationException unsupportedOperationException) {}
                        }
                        event.getPacket().getPlayerInfoDataLists().write(0, infoDataList);
                    }
                    catch (Exception | NoClassDefFoundError e) {
                        if (VanishIndication.this.suppressErrors) break block7;
                        VanishIndication.this.plugin.logException(e);
                        this.plugin.getLogger().warning("IMPORTANT: Please make sure that you are using the latest dev-build of ProtocolLib and that your server is up-to-date! This error likely happened inside of ProtocolLib code which is out of SuperVanish's control. It's part of an optional feature module and can be removed safely by disabling MarkVanishedPlayersAsSpectators in the config file. Please report this error if you can reproduce it on an up-to-date server with only latest ProtocolLib and latest SV installed.");
                        VanishIndication.this.suppressErrors = true;
                    }
                }
            }
        });
    }

    private void sendPlayerInfoChangeGameModePacket(Player p, Player change, boolean spectator) {
        PacketContainer packet = new PacketContainer(PacketType.Play.Server.PLAYER_INFO);
        packet.getPlayerInfoAction().write(0, (Object)EnumWrappers.PlayerInfoAction.UPDATE_GAME_MODE);
        ArrayList<PlayerInfoData> data = new ArrayList<PlayerInfoData>();
        int ping = ThreadLocalRandom.current().nextInt(20) + 15;
        data.add(new PlayerInfoData(WrappedGameProfile.fromPlayer((Player)change), ping, spectator ? EnumWrappers.NativeGameMode.SPECTATOR : EnumWrappers.NativeGameMode.fromBukkit((GameMode)change.getGameMode()), WrappedChatComponent.fromText((String)change.getPlayerListName())));
        packet.getPlayerInfoDataLists().write(0, data);
        try {
            ProtocolLibrary.getProtocolManager().sendServerPacket(p, packet);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Cannot send packet", e);
        }
    }
}

