/*
 * Decompiled with CFR 0.152.
 */
package de.myzelyam.supervanish.hooks;

import de.myzelyam.api.vanish.PlayerHideEvent;
import de.myzelyam.api.vanish.PlayerShowEvent;
import de.myzelyam.supervanish.SuperVanish;
import de.myzelyam.supervanish.hooks.PluginHook;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.dynmap.DynmapAPI;

public class DynmapHook
extends PluginHook {
    private final boolean sendJoinLeave;
    private final SuperVanish superVanish;

    public DynmapHook(SuperVanish superVanish) {
        super(superVanish);
        this.superVanish = superVanish;
        this.sendJoinLeave = superVanish.getSettings().getBoolean("HookOptions.DynmapSendJoinLeaveMessages") && !superVanish.getMessage("DynmapFakeJoin").equals("");
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onVanish(PlayerHideEvent e) {
        Player p = e.getPlayer();
        DynmapAPI dynmap = (DynmapAPI)this.plugin;
        dynmap.setPlayerVisiblity(p, false);
        if (this.sendJoinLeave) {
            dynmap.sendBroadcastToWeb("", this.superVanish.replacePlaceholders(this.superVanish.getMessage("DynmapFakeQuit"), p));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onReappear(PlayerShowEvent e) {
        Player p = e.getPlayer();
        DynmapAPI dynmap = (DynmapAPI)this.plugin;
        dynmap.setPlayerVisiblity(p, true);
        if (this.sendJoinLeave) {
            dynmap.sendBroadcastToWeb("", this.superVanish.replacePlaceholders(this.superVanish.getMessage("DynmapFakeJoin"), p));
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onJoin(PlayerJoinEvent e) {
        Player p = e.getPlayer();
        DynmapAPI dynmap = (DynmapAPI)this.plugin;
        if (this.superVanish.getVanishStateMgr().isVanished(p.getUniqueId())) {
            dynmap.setPlayerVisiblity(p, false);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onQuit(PlayerQuitEvent e) {
        Player p = e.getPlayer();
        DynmapAPI dynmap = (DynmapAPI)this.plugin;
        if (this.superVanish.getVanishStateMgr().isVanished(p.getUniqueId())) {
            dynmap.setPlayerVisiblity(p, true);
        }
    }
}

