/*
 * Decompiled with CFR 0.152.
 */
package de.myzelyam.supervanish.hooks;

import be.maximvdw.placeholderapi.PlaceholderAPI;
import de.myzelyam.supervanish.SuperVanish;
import de.myzelyam.supervanish.hooks.PluginHook;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class MVdWPlaceholderAPIHook
extends PluginHook {
    private final String yes;
    private final String no;
    private final String prefix;
    private final String suffix;

    public MVdWPlaceholderAPIHook(SuperVanish superVanish) {
        super(superVanish);
        this.yes = superVanish.getMessage("PlaceholderIsVanishedYes");
        this.no = superVanish.getMessage("PlaceholderIsVanishedNo");
        this.prefix = superVanish.getMessage("PlaceholderVanishPrefix");
        this.suffix = superVanish.getMessage("PlaceholderVanishSuffix");
    }

    @Override
    public void onPluginEnable(Plugin plugin) {
        PlaceholderAPI.registerPlaceholder((Plugin)this.superVanish, (String)"supervanish_isvanished", e -> {
            try {
                Player p = e.getPlayer();
                if (p == null) {
                    return this.no;
                }
                try {
                    return this.superVanish.getVanishStateMgr().isVanished(p.getUniqueId()) ? this.yes : this.no;
                }
                catch (Exception er) {
                    this.superVanish.logException(er);
                    return null;
                }
            }
            catch (Throwable t) {
                if (!(t instanceof NoClassDefFoundError) && !(t instanceof ConcurrentModificationException)) {
                    this.superVanish.logException(t);
                }
                return this.no;
            }
        });
        PlaceholderAPI.registerPlaceholder((Plugin)this.superVanish, (String)"supervanish_vanishprefix", e -> {
            try {
                Player p = e.getPlayer();
                if (p == null) {
                    return "";
                }
                try {
                    return this.superVanish.getVanishStateMgr().isVanished(p.getUniqueId()) ? this.prefix : "";
                }
                catch (Exception er) {
                    this.superVanish.logException(er);
                    return null;
                }
            }
            catch (Throwable t) {
                if (!(t instanceof NoClassDefFoundError) && !(t instanceof ConcurrentModificationException)) {
                    this.superVanish.logException(t);
                }
                return "";
            }
        });
        PlaceholderAPI.registerPlaceholder((Plugin)this.superVanish, (String)"supervanish_vanishsuffix", e -> {
            try {
                Player p = e.getPlayer();
                if (p == null) {
                    return "";
                }
                try {
                    return this.superVanish.getVanishStateMgr().isVanished(p.getUniqueId()) ? this.suffix : "";
                }
                catch (Exception er) {
                    this.superVanish.logException(er);
                    return null;
                }
            }
            catch (Throwable t) {
                if (!(t instanceof NoClassDefFoundError) && !(t instanceof ConcurrentModificationException)) {
                    this.superVanish.logException(t);
                }
                return "";
            }
        });
        PlaceholderAPI.registerPlaceholder((Plugin)this.superVanish, (String)"supervanish_vanishedplayers", e -> {
            try {
                Player p = e.getPlayer();
                Collection<UUID> onlineVanishedPlayers = this.superVanish.getVanishStateMgr().getOnlineVanishedPlayers();
                Object playerListMessage = "";
                for (UUID uuid : onlineVanishedPlayers) {
                    Player onlineVanished = Bukkit.getPlayer((UUID)uuid);
                    if (onlineVanished == null || p != null && this.superVanish.getSettings().getBoolean("IndicationFeatures.LayeredPermissions.HideInvisibleInCommands", false) && !this.superVanish.hasPermissionToSee(p, onlineVanished)) continue;
                    playerListMessage = (String)playerListMessage + onlineVanished.getName() + ", ";
                }
                return ((String)playerListMessage).length() > 3 ? ((String)playerListMessage).substring(0, ((String)playerListMessage).length() - 2) : playerListMessage;
            }
            catch (Throwable t) {
                if (!(t instanceof NoClassDefFoundError) && !(t instanceof ConcurrentModificationException)) {
                    this.superVanish.logException(t);
                }
                return "";
            }
        });
        PlaceholderAPI.registerPlaceholder((Plugin)this.superVanish, (String)"supervanish_playercount", e -> {
            try {
                Player p = e.getPlayer();
                int playercount = Bukkit.getOnlinePlayers().size();
                for (UUID uuid : this.superVanish.getVanishStateMgr().getOnlineVanishedPlayers()) {
                    Player onlineVanished = Bukkit.getPlayer((UUID)uuid);
                    if (onlineVanished == null || p != null && this.superVanish.canSee(p, onlineVanished)) continue;
                    --playercount;
                }
                return "" + playercount;
            }
            catch (Throwable t) {
                if (!(t instanceof NoClassDefFoundError) && !(t instanceof ConcurrentModificationException)) {
                    this.superVanish.logException(t);
                }
                return "" + Bukkit.getOnlinePlayers().size();
            }
        });
    }
}

