/*
 * Decompiled with CFR 0.152.
 */
package de.myzelyam.supervanish.hooks;

import com.lishid.openinv.IOpenInv;
import com.lishid.openinv.internal.ISpecialInventory;
import de.myzelyam.api.vanish.PlayerShowEvent;
import de.myzelyam.api.vanish.PostPlayerHideEvent;
import de.myzelyam.supervanish.SuperVanish;
import de.myzelyam.supervanish.hooks.PluginHook;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public class OpenInvHook
extends PluginHook {
    private boolean errorLogged = false;
    private final Set<UUID> alreadyHiddenBeforeVanishing = new HashSet<UUID>();

    public OpenInvHook(SuperVanish superVanish) {
        super(superVanish);
    }

    @EventHandler
    public void onVanish(PostPlayerHideEvent e) {
        block5: {
            try {
                Player p = e.getPlayer();
                IOpenInv openInv = (IOpenInv)this.plugin;
                if (openInv.getSilentContainerStatus((OfflinePlayer)p)) {
                    this.alreadyHiddenBeforeVanishing.add(p.getUniqueId());
                } else {
                    if (!p.hasPermission("sv.silentchest")) {
                        return;
                    }
                    openInv.setSilentContainerStatus((OfflinePlayer)p, true);
                }
            }
            catch (Exception | NoClassDefFoundError | NoSuchMethodError er) {
                if (this.errorLogged) break block5;
                this.superVanish.logException(er);
                this.errorLogged = true;
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onReappear(PlayerShowEvent e) {
        block3: {
            try {
                Player p = e.getPlayer();
                IOpenInv openInv = (IOpenInv)this.plugin;
                if (!this.alreadyHiddenBeforeVanishing.remove(p.getUniqueId())) {
                    openInv.setSilentContainerStatus((OfflinePlayer)p, false);
                }
            }
            catch (Exception | NoClassDefFoundError | NoSuchMethodError er) {
                if (this.errorLogged) break block3;
                this.superVanish.logException(er);
                this.errorLogged = true;
            }
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onJoin(PlayerJoinEvent e) {
        block6: {
            try {
                Player p = e.getPlayer();
                IOpenInv openInv = (IOpenInv)this.plugin;
                if (this.superVanish.getVanishStateMgr().isVanished(p.getUniqueId())) {
                    if (openInv.getSilentContainerStatus((OfflinePlayer)p)) {
                        this.alreadyHiddenBeforeVanishing.add(p.getUniqueId());
                    } else {
                        if (!p.hasPermission("sv.silentchest")) {
                            return;
                        }
                        openInv.setSilentContainerStatus((OfflinePlayer)p, true);
                    }
                }
            }
            catch (Exception | NoClassDefFoundError | NoSuchMethodError er) {
                if (this.errorLogged) break block6;
                this.superVanish.logException(er);
                this.errorLogged = true;
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onQuit(PlayerQuitEvent e) {
        block3: {
            try {
                Player p = e.getPlayer();
                IOpenInv openInv = (IOpenInv)this.plugin;
                if (this.superVanish.getVanishStateMgr().isVanished(p.getUniqueId()) && !this.alreadyHiddenBeforeVanishing.remove(p.getUniqueId())) {
                    openInv.setSilentContainerStatus((OfflinePlayer)p, false);
                }
            }
            catch (Exception | NoClassDefFoundError | NoSuchMethodError er) {
                if (this.errorLogged) break block3;
                this.superVanish.logException(er);
                this.errorLogged = true;
            }
        }
    }

    public boolean openPlayerInventory(Player vanished, Player target) {
        IOpenInv openInv = (IOpenInv)this.plugin;
        try {
            openInv.openInventory(vanished, (ISpecialInventory)openInv.getSpecialInventory(target, true));
        }
        catch (Exception | NoClassDefFoundError | NoSuchMethodError e) {
            if (!this.errorLogged) {
                this.superVanish.logException(e);
                this.errorLogged = true;
            }
            return false;
        }
        return true;
    }
}

