/*
 * Decompiled with CFR 0.152.
 */
package de.myzelyam.supervanish.hooks;

import de.myzelyam.supervanish.SuperVanish;
import de.myzelyam.supervanish.hooks.CitizensHook;
import de.myzelyam.supervanish.hooks.DynmapHook;
import de.myzelyam.supervanish.hooks.EssentialsHook;
import de.myzelyam.supervanish.hooks.InvalidPluginHookException;
import de.myzelyam.supervanish.hooks.MVdWPlaceholderAPIHook;
import de.myzelyam.supervanish.hooks.OpenInvHook;
import de.myzelyam.supervanish.hooks.PlaceholderAPIHook;
import de.myzelyam.supervanish.hooks.PluginHook;
import de.myzelyam.supervanish.hooks.TrailGUIHook;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.plugin.Plugin;

public class PluginHookMgr
implements Listener {
    private static final Map<String, Class<? extends PluginHook>> REGISTERED_HOOKS = new HashMap<String, Class<? extends PluginHook>>(){
        {
            this.put("Essentials", EssentialsHook.class);
            this.put("Citizens", CitizensHook.class);
            this.put("PlaceholderAPI", PlaceholderAPIHook.class);
            this.put("dynmap", DynmapHook.class);
            this.put("TrailGUI", TrailGUIHook.class);
            this.put("MVdWPlaceholderAPI", MVdWPlaceholderAPIHook.class);
            this.put("OpenInv", OpenInvHook.class);
        }
    };
    private final SuperVanish plugin;
    private Set<PluginHook> activeHooks = new HashSet<PluginHook>();

    public PluginHookMgr(SuperVanish plugin) {
        this.plugin = plugin;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        for (Plugin alreadyEnabledPlugin : Bukkit.getPluginManager().getPlugins()) {
            if (!alreadyEnabledPlugin.isEnabled()) continue;
            this.onPluginEnable(new PluginEnableEvent(alreadyEnabledPlugin));
        }
    }

    @EventHandler
    public void onPluginEnable(PluginEnableEvent e) {
        Plugin plugin = e.getPlugin();
        if (REGISTERED_HOOKS.get(plugin.getName()) == null) {
            return;
        }
        if (this.isHookDisabled(plugin.getName())) {
            return;
        }
        Object hook = null;
        try {
            hook = REGISTERED_HOOKS.get(plugin.getName()).getConstructor(SuperVanish.class).newInstance(this.plugin);
            ((PluginHook)hook).setPlugin(plugin);
            ((PluginHook)hook).onPluginEnable(plugin);
            Bukkit.getPluginManager().registerEvents((Listener)hook, plugin);
            this.activeHooks.add((PluginHook)hook);
            this.plugin.log(Level.INFO, "Hooked into " + plugin.getName());
        }
        catch (NoClassDefFoundError er) {
            Bukkit.getLogger().warning("NoClassDefFoundError for SV-Hook(v" + this.plugin.getDescription().getVersion() + ") " + (hook != null ? hook.getClass().getSimpleName() : "?") + " of plugin " + plugin.getName() + " v" + plugin.getDescription().getVersion() + ", please report this if you are using the latest version of that plugin!");
        }
        catch (Exception er) {
            if (er.getMessage() != null && er.getMessage().contains("Unable to find handler list for event")) {
                this.plugin.log(Level.WARNING, er.getMessage() + "; This is not an issue with SuperVanish");
                return;
            }
            if (er.getCause() != null && er.getCause().getMessage() != null && er.getCause().getMessage().contains("Unable to find handler list for event ")) {
                this.plugin.log(Level.WARNING, er.getCause().getMessage() + "; This is not an issue with SuperVanish");
                return;
            }
            this.plugin.logException(new InvalidPluginHookException(er));
            this.plugin.log(Level.WARNING, "Affected by this error is only the " + plugin.getName() + "-Hook, all other hooks and features aren't affected.");
        }
    }

    private boolean isHookDisabled(String pluginName) {
        if (pluginName.equalsIgnoreCase("dynmap")) {
            return !this.plugin.getSettings().getBoolean("HookOptions.EnableDynmapHook");
        }
        return !this.plugin.getSettings().getBoolean("HookOptions.Enable" + pluginName + "Hook", true);
    }

    @EventHandler
    public void onPluginDisable(PluginDisableEvent e) {
        Plugin plugin = e.getPlugin();
        PluginHook hook = this.getActiveHook(plugin);
        if (hook == null) {
            return;
        }
        try {
            hook.onPluginDisable(plugin);
        }
        catch (Exception e1) {
            this.plugin.logException(new InvalidPluginHookException(e1));
        }
        hook.setPlugin(null);
        this.activeHooks.remove(hook);
    }

    private PluginHook getActiveHook(Plugin plugin) {
        for (PluginHook hook : this.activeHooks) {
            if (hook.getPlugin() != plugin) continue;
            return hook;
        }
        return null;
    }

    public boolean isHookActive(Class<? extends PluginHook> hookClass) {
        for (PluginHook hook : this.activeHooks) {
            if (!hook.getClass().equals(hookClass)) continue;
            return true;
        }
        return false;
    }
}

