/*
 * Decompiled with CFR 0.152.
 */
package de.myzelyam.supervanish.listeners;

import de.myzelyam.supervanish.SuperVanish;
import de.myzelyam.supervanish.features.Broadcast;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.EventExecutor;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class JoinListener
implements EventExecutor,
Listener {
    private final SuperVanish plugin;

    public JoinListener(SuperVanish plugin) {
        this.plugin = plugin;
    }

    public void execute(Listener l, Event event) {
        try {
            if (event instanceof PlayerJoinEvent) {
                PlayerJoinEvent e = (PlayerJoinEvent)event;
                final Player p = e.getPlayer();
                for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                    if (!this.plugin.getVanishStateMgr().isVanished(onlinePlayer.getUniqueId()) || this.plugin.hasPermissionToSee(p, onlinePlayer)) continue;
                    this.plugin.getVisibilityChanger().getHider().setHidden(onlinePlayer, p, true);
                }
                if (this.plugin.getVanishStateMgr().isVanished(p.getUniqueId())) {
                    for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                        if (this.plugin.hasPermissionToSee(onlinePlayer, p)) continue;
                        this.plugin.getVisibilityChanger().getHider().setHidden(p, onlinePlayer, true);
                    }
                    if (this.plugin.getSettings().getBoolean("MessageOptions.HideRealJoinQuitMessages")) {
                        e.setJoinMessage(null);
                        Broadcast.announceSilentJoin(p, this.plugin);
                    }
                    if (this.plugin.getSettings().getBoolean("MessageOptions.RemindVanishedOnJoin")) {
                        this.plugin.sendMessage((CommandSender)p, "RemindingMessage", p);
                    }
                    if (this.plugin.getActionBarMgr() != null && this.plugin.getSettings().getBoolean("MessageOptions.DisplayActionBar")) {
                        this.plugin.getActionBarMgr().addActionBar(p);
                    }
                    p.setSleepingIgnored(true);
                    if (this.plugin.getSettings().getBoolean("InvisibilityFeatures.Fly.Enable")) {
                        p.setAllowFlight(true);
                    }
                    p.setMetadata("vanished", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)true));
                } else {
                    p.removeMetadata("vanished", (Plugin)this.plugin);
                }
                if ((p.hasPermission("sv.recreatecfg") || p.hasPermission("sv.recreatefiles")) && (this.plugin.getConfigMgr().isSettingsUpdateRequired() || this.plugin.getConfigMgr().isMessagesUpdateRequired())) {
                    String currentVersion = this.plugin.getDescription().getVersion();
                    boolean isDismissed = this.plugin.getPlayerData().getBoolean("PlayerData." + String.valueOf(p.getUniqueId()) + ".dismissed." + currentVersion.replace(".", "_"), false);
                    if (!isDismissed) {
                        new BukkitRunnable(this){
                            final /* synthetic */ JoinListener this$0;
                            {
                                this.this$0 = this$0;
                            }

                            public void run() {
                                this.this$0.plugin.sendMessage((CommandSender)p, "RecreationRequiredMsg", p);
                            }
                        }.runTaskLater((Plugin)this.plugin, 1L);
                    }
                }
            }
        }
        catch (Exception er) {
            this.plugin.logException(er);
        }
    }
}

