/*
 * Decompiled with CFR 0.152.
 */
package de.myzelyam.supervanish.listeners;

import de.myzelyam.supervanish.SuperVanish;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerInteractEvent;

public class PlayerBlockModifyListener
implements Listener {
    private final SuperVanish plugin;

    public PlayerBlockModifyListener(SuperVanish plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onInteract(PlayerInteractEvent e) {
        try {
            if (!this.plugin.getVanishStateMgr().isVanished(e.getPlayer().getUniqueId())) {
                return;
            }
            if (e.getAction().equals((Object)Action.PHYSICAL) && e.getClickedBlock() != null) {
                if (!this.plugin.getSettings().getBoolean("InvisibilityFeatures.DisablePressurePlates")) {
                    return;
                }
                String material = e.getClickedBlock().getType().toString();
                List<String> disallowedMaterials = Arrays.asList("STONE_PLATE", "GOLD_PLATE", "IRON_PLATE", "WOOD_PLATE", "TRIPWIRE", "PRESSURE_PLATE");
                for (String disallowedMaterial : disallowedMaterials) {
                    if (!material.equals(disallowedMaterial) && !material.contains(disallowedMaterial)) continue;
                    e.setCancelled(true);
                }
            }
        }
        catch (Exception er) {
            this.plugin.logException(er);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlace(BlockPlaceEvent e) {
        try {
            if (this.plugin.getSettings().getBoolean("RestrictiveOptions.PreventBlockPlacing")) {
                Player p = e.getPlayer();
                Collection<UUID> vanishedPlayers = this.plugin.getVanishStateMgr().getOnlineVanishedPlayers();
                if (vanishedPlayers.contains(p.getUniqueId()) && !p.hasPermission("sv.placeblocks")) {
                    e.setCancelled(true);
                    this.plugin.sendMessage((CommandSender)e.getPlayer(), "BlockPlaceDenied", e.getPlayer());
                }
            }
        }
        catch (Exception er) {
            this.plugin.logException(er);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBreak(BlockBreakEvent e) {
        try {
            if (this.plugin.getSettings().getBoolean("RestrictiveOptions.PreventBlockBreaking")) {
                Player p = e.getPlayer();
                if (this.plugin.getVanishStateMgr().isVanished(p.getUniqueId()) && !p.hasPermission("sv.breakblocks")) {
                    e.setCancelled(true);
                    this.plugin.sendMessage((CommandSender)e.getPlayer(), "BlockBreakDenied", e.getPlayer());
                }
            }
        }
        catch (Exception er) {
            this.plugin.logException(er);
        }
    }
}

