/*
 * Decompiled with CFR 0.152.
 */
package de.myzelyam.supervanish.listeners;

import de.myzelyam.supervanish.SuperVanish;
import de.myzelyam.supervanish.commands.CommandAction;
import de.myzelyam.supervanish.features.Broadcast;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.EventExecutor;

public class QuitListener
implements EventExecutor,
Listener {
    private final SuperVanish plugin;

    public QuitListener(SuperVanish plugin) {
        this.plugin = plugin;
    }

    public void execute(Listener l, Event event) {
        try {
            if (event instanceof PlayerQuitEvent) {
                PlayerQuitEvent e = (PlayerQuitEvent)event;
                FileConfiguration config = this.plugin.getConfig();
                Player p = e.getPlayer();
                if (this.plugin.getVanishStateMgr().isVanished(p.getUniqueId())) {
                    if (this.plugin.getActionBarMgr() != null && this.plugin.getSettings().getBoolean("MessageOptions.DisplayActionBar")) {
                        this.plugin.getActionBarMgr().removeActionBar(p);
                    }
                    boolean noMsg = false;
                    if (this.plugin.getSettings().getBoolean("VanishStateFeatures.ReappearOnQuit") || this.plugin.getSettings().getBoolean("VanishStateFeatures.CheckPermissionOnQuit") && !CommandAction.VANISH_SELF.checkPermission((CommandSender)p, this.plugin)) {
                        this.plugin.getVanishStateMgr().setVanishedState(p.getUniqueId(), p.getName(), false, null);
                        if (!config.getBoolean("MessageOptions.ReappearOnQuitHideLeaveMsg")) {
                            noMsg = true;
                        }
                    }
                    if (!noMsg && config.getBoolean("MessageOptions.HideRealJoinQuitMessages")) {
                        e.setQuitMessage(null);
                        Broadcast.announceSilentQuit(p, this.plugin);
                    }
                }
                this.plugin.removeVanishPlayer(this.plugin.getVanishPlayer(p));
            }
        }
        catch (Exception er) {
            this.plugin.logException(er);
        }
    }
}

