/*
 * Decompiled with CFR 0.152.
 */
package de.myzelyam.supervanish.listeners;

import de.myzelyam.supervanish.SuperVanish;
import java.util.Iterator;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.server.TabCompleteEvent;

public class TabCompleteListener
implements Listener {
    private final SuperVanish plugin;
    private boolean errorLogged = false;

    public TabCompleteListener(SuperVanish plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onTabComplete(TabCompleteEvent e) {
        block6: {
            try {
                if (!(e.getSender() instanceof Player)) {
                    return;
                }
                Player p = (Player)e.getSender();
                Set hiddenNames = this.plugin.getVanishStateMgr().getOnlineVanishedPlayers().stream().map(Bukkit::getPlayer).filter(Objects::nonNull).filter(vanishedPlayer -> !this.plugin.canSee(p, (Player)vanishedPlayer)).map(HumanEntity::getName).map(name -> name.toLowerCase(Locale.ENGLISH)).collect(Collectors.toSet());
                Iterator it = e.getCompletions().iterator();
                while (it.hasNext()) {
                    String completion = (String)it.next();
                    boolean allowedCompletion = !hiddenNames.contains(completion.toLowerCase(Locale.ENGLISH));
                    if (allowedCompletion) continue;
                    it.remove();
                }
            }
            catch (UnsupportedOperationException uoe) {
                if (!this.errorLogged) {
                    this.plugin.getLogger().warning("UnsupportedOperationException while modifying TabCompleteEvent");
                    this.errorLogged = true;
                }
            }
            catch (Exception er) {
                if (this.errorLogged) break block6;
                this.plugin.logException(er);
                this.errorLogged = true;
            }
        }
    }
}

