/*
 * Decompiled with CFR 0.152.
 */
package de.myzelyam.supervanish.visibility;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import de.myzelyam.supervanish.SuperVanish;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ActionBarMgr {
    private final SuperVanish plugin;
    private final List<Player> actionBars = new ArrayList<Player>();

    public ActionBarMgr(SuperVanish plugin) {
        this.plugin = plugin;
        this.startTask();
    }

    private void startTask() {
        new BukkitRunnable(){

            public void run() {
                for (Player p : ActionBarMgr.this.actionBars) {
                    try {
                        ActionBarMgr.this.sendActionBar(p, ActionBarMgr.this.plugin.replacePlaceholders(ActionBarMgr.this.plugin.getMessage("ActionBarMessage"), p));
                    }
                    catch (Exception | NoClassDefFoundError | NoSuchMethodError e) {
                        this.cancel();
                        ActionBarMgr.this.plugin.logException(e);
                        ActionBarMgr.this.plugin.getLogger().warning("IMPORTANT: Please make sure that you are using the latest dev-build of ProtocolLib and that your server is up-to-date! This error likely happened inside of ProtocolLib code which is out of SuperVanish's control. It's part of an optional feature module and can be removed safely by disabling DisplayActionBar in the config file. Please report this error if you can reproduce it on an up-to-date server with only latest ProtocolLib and latest SV installed.");
                    }
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 40L);
    }

    private void sendActionBar(Player p, String bar) {
        try {
            Class.forName("net.md_5.bungee.api.chat.ComponentBuilder");
            p.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)bar));
        }
        catch (ClassNotFoundException | NoClassDefFoundError | NoSuchMethodError er) {
            String json = "{\"text\": \"" + ChatColor.translateAlternateColorCodes((char)'&', (String)bar) + "\"}";
            WrappedChatComponent msg = WrappedChatComponent.fromJson((String)json);
            PacketContainer chatMsg = new PacketContainer(PacketType.Play.Server.CHAT);
            chatMsg.getChatComponents().write(0, (Object)msg);
            if (this.plugin.getVersionUtil().isOneDotXOrHigher(12)) {
                try {
                    chatMsg.getChatTypes().write(0, (Object)EnumWrappers.ChatType.GAME_INFO);
                }
                catch (NoSuchMethodError e) {
                    p.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)"SuperVanish: Please update ProtocolLib"));
                }
            } else {
                chatMsg.getBytes().write(0, (Object)2);
            }
            try {
                ProtocolLibrary.getProtocolManager().sendServerPacket(p, chatMsg);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("Cannot send packet " + String.valueOf(chatMsg), e);
            }
        }
    }

    public void addActionBar(Player p) {
        this.actionBars.add(p);
    }

    public void removeActionBar(Player p) {
        this.actionBars.remove(p);
    }
}

