/*
 * Decompiled with CFR 0.152.
 */
package de.myzelyam.supervanish.visibility;

import de.myzelyam.api.vanish.PlayerVanishStateChangeEvent;
import de.myzelyam.supervanish.SuperVanish;
import de.myzelyam.supervanish.visibility.VanishStateMgr;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;

public class FileVanishStateMgr
extends VanishStateMgr {
    private final SuperVanish plugin;

    public FileVanishStateMgr(SuperVanish plugin) {
        super(plugin);
        this.plugin = plugin;
    }

    @Override
    public boolean isVanished(UUID uuid) {
        return this.getVanishedPlayersOnFile().contains(uuid);
    }

    @Override
    public void setVanishedState(UUID uuid, String name, boolean hide, String causeName) {
        PlayerVanishStateChangeEvent event = new PlayerVanishStateChangeEvent(uuid, name, hide, causeName);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        List vanishedPlayerUUIDStrings = this.plugin.getPlayerData().getStringList("InvisiblePlayers");
        if (hide) {
            vanishedPlayerUUIDStrings.add(uuid.toString());
        } else {
            vanishedPlayerUUIDStrings.remove(uuid.toString());
        }
        this.plugin.getPlayerData().set("InvisiblePlayers", (Object)vanishedPlayerUUIDStrings);
        if (hide) {
            this.plugin.getPlayerData().set("PlayerData." + String.valueOf(uuid) + ".information.name", (Object)name);
        }
        this.plugin.getConfigMgr().getPlayerDataFile().save();
    }

    @Override
    public Set<UUID> getVanishedPlayers() {
        return this.getVanishedPlayersOnFile();
    }

    @Override
    public Collection<UUID> getOnlineVanishedPlayers() {
        HashSet<UUID> onlineVanishedPlayers = new HashSet<UUID>();
        for (UUID vanishedUUID : this.getVanishedPlayers()) {
            if (Bukkit.getPlayer((UUID)vanishedUUID) == null) continue;
            onlineVanishedPlayers.add(vanishedUUID);
        }
        return onlineVanishedPlayers;
    }

    public UUID getVanishedUUIDFromNameOnFile(String name) {
        for (UUID uuid : this.getVanishedPlayersOnFile()) {
            if (!this.plugin.getPlayerData().getString("PlayerData." + String.valueOf(uuid) + ".information.name").equalsIgnoreCase(name)) continue;
            return uuid;
        }
        return null;
    }

    private Set<UUID> getVanishedPlayersOnFile() {
        List vanishedPlayerUUIDStrings = this.plugin.getPlayerData().getStringList("InvisiblePlayers");
        HashSet<UUID> vanishedPlayerUUIDs = new HashSet<UUID>();
        for (String uuidString : new ArrayList(vanishedPlayerUUIDStrings)) {
            try {
                vanishedPlayerUUIDs.add(UUID.fromString(uuidString));
            }
            catch (IllegalArgumentException e) {
                vanishedPlayerUUIDStrings.remove(uuidString);
                this.plugin.log(Level.WARNING, "The data.yml file contains an invalid player uuid, deleting it.");
                this.plugin.getPlayerData().set("InvisiblePlayers", (Object)vanishedPlayerUUIDStrings);
                this.plugin.getConfigMgr().getPlayerDataFile().save();
            }
        }
        return vanishedPlayerUUIDs;
    }

    private void setVanishedPlayersOnFile(Set<UUID> vanishedPlayers) {
        ArrayList<String> vanishedPlayerUUIDStrings = new ArrayList<String>();
        for (UUID uuid : vanishedPlayers) {
            vanishedPlayerUUIDStrings.add(uuid.toString());
        }
        this.plugin.getPlayerData().set("InvisiblePlayers", vanishedPlayerUUIDStrings);
        this.plugin.getConfigMgr().getPlayerDataFile().save();
    }
}

