/*
 * Decompiled with CFR 0.152.
 */
package de.myzelyam.supervanish.visibility;

import com.destroystokyo.paper.event.server.PaperServerListPingEvent;
import de.myzelyam.supervanish.SuperVanish;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;

public class PaperServerPingListener
implements Listener {
    private boolean errorLogged = false;
    private final SuperVanish plugin;

    public PaperServerPingListener(SuperVanish plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onServerListPing(PaperServerListPingEvent e) {
        block5: {
            try {
                FileConfiguration settings = this.plugin.getSettings();
                if (!settings.getBoolean("ExternalInvisibility.ServerList.AdjustAmountOfOnlinePlayers") && !settings.getBoolean("ExternalInvisibility.ServerList.AdjustListOfLoggedInPlayers")) {
                    return;
                }
                Collection<UUID> onlineVanishedPlayers = this.plugin.getVanishStateMgr().getOnlineVanishedPlayers();
                int vanishedPlayersCount = onlineVanishedPlayers.size();
                int playerCount = Bukkit.getOnlinePlayers().size();
                if (settings.getBoolean("ExternalInvisibility.ServerList.AdjustAmountOfOnlinePlayers")) {
                    e.setNumPlayers(playerCount - vanishedPlayersCount);
                }
                if (settings.getBoolean("ExternalInvisibility.ServerList.AdjustListOfLoggedInPlayers")) {
                    List playerSample = e.getPlayerSample();
                    playerSample.removeIf(profile -> onlineVanishedPlayers.contains(profile.getId()));
                }
            }
            catch (Exception er) {
                if (this.errorLogged) break block5;
                this.plugin.logException(er);
                this.errorLogged = true;
            }
        }
    }
}

