/*
 * Decompiled with CFR 0.152.
 */
package de.myzelyam.supervanish.visibility;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import com.comphenix.protocol.wrappers.WrappedGameProfile;
import com.comphenix.protocol.wrappers.WrappedServerPing;
import de.myzelyam.supervanish.SuperVanish;
import de.myzelyam.supervanish.visibility.PaperServerPingListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class ServerListPacketListener
extends PacketAdapter {
    private final SuperVanish plugin;
    private boolean errorLogged = false;

    public ServerListPacketListener(SuperVanish plugin) {
        super((Plugin)plugin, ListenerPriority.NORMAL, new PacketType[]{PacketType.Status.Server.SERVER_INFO});
        this.plugin = plugin;
    }

    public ServerListPacketListener(SuperVanish plugin, boolean use_legacy) {
        super((Plugin)plugin, ListenerPriority.NORMAL, new PacketType[]{PacketType.Status.Server.OUT_SERVER_INFO});
        this.plugin = plugin;
    }

    public static void register(SuperVanish plugin) {
        try {
            Class.forName("com.destroystokyo.paper.event.server.PaperServerListPingEvent");
            plugin.getLogger().log(Level.INFO, "Hooked into PaperSpigot for server list ping support");
            plugin.getServer().getPluginManager().registerEvents((Listener)new PaperServerPingListener(plugin), (Plugin)plugin);
        }
        catch (ClassNotFoundException ignored) {
            if (plugin.getVersionUtil().isOneDotXOrHigher(19)) {
                ProtocolLibrary.getProtocolManager().addPacketListener((PacketListener)new ServerListPacketListener(plugin));
            }
            ProtocolLibrary.getProtocolManager().addPacketListener((PacketListener)new ServerListPacketListener(plugin, true));
        }
    }

    public static boolean isEnabled(SuperVanish plugin) {
        FileConfiguration config = plugin.getSettings();
        return config.getBoolean("ExternalInvisibility.ServerList.AdjustAmountOfOnlinePlayers") || config.getBoolean("ExternalInvisibility.ServerList.AdjustListOfLoggedInPlayers");
    }

    public void onPacketSending(PacketEvent e) {
        block10: {
            try {
                FileConfiguration settings = this.plugin.getSettings();
                if (!settings.getBoolean("ExternalInvisibility.ServerList.AdjustAmountOfOnlinePlayers") && !settings.getBoolean("ExternalInvisibility.ServerList.AdjustListOfLoggedInPlayers")) {
                    return;
                }
                WrappedServerPing ping = (WrappedServerPing)e.getPacket().getServerPings().read(0);
                Collection<UUID> onlineVanishedPlayers = this.plugin.getVanishStateMgr().getOnlineVanishedPlayers();
                int vanishedPlayersCount = this.plugin.getVanishStateMgr().getOnlineVanishedPlayers().size();
                int playerCount = Bukkit.getOnlinePlayers().size();
                if (settings.getBoolean("ExternalInvisibility.ServerList.AdjustAmountOfOnlinePlayers")) {
                    ping.setPlayersOnline(playerCount - vanishedPlayersCount);
                }
                if (settings.getBoolean("ExternalInvisibility.ServerList.AdjustListOfLoggedInPlayers")) {
                    ArrayList wrappedGameProfiles = new ArrayList(ping.getPlayers());
                    Iterator iterator = wrappedGameProfiles.iterator();
                    while (iterator.hasNext()) {
                        if (!onlineVanishedPlayers.contains(((WrappedGameProfile)iterator.next()).getUUID())) continue;
                        iterator.remove();
                    }
                    ping.setPlayers(wrappedGameProfiles);
                }
                e.getPacket().getServerPings().write(0, (Object)ping);
            }
            catch (Exception er) {
                if (this.errorLogged) break block10;
                if (er.getMessage() != null && er.getMessage().contains("Unable to construct new instance using public net.minecraft.network.protocol.status.ServerPing")) {
                    this.plugin.getLogger().warning("The spigot-sided serverlist features are not supported by ProtocolLib on your server. Please make sure you are using the latest ProtocolLib dev build. (" + er.getMessage() + ")\n");
                } else if (er.getMessage() != null && er.getMessage().contains("Cannot assign field \"online\" because \"this.playerSample\" is null")) {
                    this.plugin.getLogger().warning("The spigot-sided serverlist features are not supported yet by ProtocolLib. Please make sure you are using the latest ProtocolLib dev build.");
                } else {
                    this.plugin.logException(er);
                }
                this.errorLogged = true;
            }
        }
    }
}

