/*
 * Decompiled with CFR 0.152.
 */
package de.myzelyam.supervanish.visibility.hiders;

import de.myzelyam.supervanish.SuperVanish;
import de.myzelyam.supervanish.utils.BukkitPlayerHidingUtil;
import de.myzelyam.supervanish.visibility.hiders.PlayerHider;
import de.myzelyam.supervanish.visibility.hiders.modules.PlayerInfoModule;
import de.myzelyam.supervanish.visibility.hiders.modules.TabCompleteModule;
import java.util.Set;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PreventionHider
extends PlayerHider
implements Runnable {
    private int taskId;

    public PreventionHider(SuperVanish plugin) {
        super(plugin);
        if (!BukkitPlayerHidingUtil.isNewPlayerHidingAPISupported(plugin)) {
            this.taskId = plugin.getServer().getScheduler().runTaskTimer((Plugin)plugin, (Runnable)this, 2L, 2L).getTaskId();
        }
        if (plugin.isUseProtocolLib() && plugin.getVersionUtil().isOneDotXOrHigher(8) && !plugin.getVersionUtil().isOneDotXOrHigher(19) && plugin.getSettings().getBoolean("InvisibilityFeatures.ModifyTablistPackets", true)) {
            PlayerInfoModule.register(plugin, this);
        }
        if (plugin.isUseProtocolLib() && plugin.getSettings().getBoolean("InvisibilityFeatures.ModifyTabCompletePackets", true) && !plugin.getVersionUtil().isOneDotXOrHigher(21)) {
            TabCompleteModule.register(plugin, this);
        }
    }

    @Override
    public boolean setHidden(Player player, Player viewer, boolean hidden) {
        if (super.setHidden(player, viewer, hidden) || BukkitPlayerHidingUtil.isNewPlayerHidingAPISupported(this.plugin)) {
            if (hidden) {
                BukkitPlayerHidingUtil.hidePlayer(player, viewer, this.plugin);
            } else {
                BukkitPlayerHidingUtil.showPlayer(player, viewer, this.plugin);
            }
            return true;
        }
        return false;
    }

    @Override
    public String getName() {
        return "Prevention";
    }

    @Override
    public void run() {
        for (Player hidden : this.playerHiddenFromPlayersMap.keySet()) {
            if (BukkitPlayerHidingUtil.isNewPlayerHidingAPISupported(this.plugin)) {
                this.plugin.getServer().getScheduler().cancelTask(this.taskId);
                return;
            }
            for (Player viewer : (Set)this.playerHiddenFromPlayersMap.get(hidden)) {
                BukkitPlayerHidingUtil.hidePlayer(hidden, viewer, this.plugin);
            }
        }
    }
}

