/*
 * Decompiled with CFR 0.152.
 */
package de.myzelyam.supervanish.visibility.hiders.modules;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import com.comphenix.protocol.wrappers.PlayerInfoData;
import com.google.common.collect.ImmutableList;
import de.myzelyam.supervanish.SuperVanish;
import de.myzelyam.supervanish.visibility.hiders.PlayerHider;
import java.util.ArrayList;
import java.util.Collection;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PlayerInfoModule
extends PacketAdapter {
    private final PlayerHider hider;
    private final SuperVanish plugin;
    private boolean errorLogged = false;

    public PlayerInfoModule(SuperVanish plugin, PlayerHider hider) {
        super((Plugin)plugin, ListenerPriority.HIGH, new PacketType[]{PacketType.Play.Server.PLAYER_INFO});
        this.plugin = plugin;
        this.hider = hider;
    }

    public static void register(SuperVanish plugin, PlayerHider hider) {
        ProtocolLibrary.getProtocolManager().addPacketListener((PacketListener)new PlayerInfoModule(plugin, hider));
    }

    public void onPacketSending(PacketEvent event) {
        block5: {
            event.setPacket(event.getPacket().shallowClone());
            try {
                ArrayList infoDataList = new ArrayList((Collection)event.getPacket().getPlayerInfoDataLists().read(0));
                Player receiver = event.getPlayer();
                for (PlayerInfoData infoData : ImmutableList.copyOf(infoDataList)) {
                    if (!this.hider.isHidden(infoData.getProfile().getUUID(), receiver)) continue;
                    infoDataList.remove(infoData);
                }
                if (infoDataList.isEmpty()) {
                    event.setCancelled(true);
                }
                event.getPacket().getPlayerInfoDataLists().write(0, infoDataList);
            }
            catch (Exception | NoClassDefFoundError e) {
                if (e.getMessage() != null && e.getMessage().endsWith("is not supported for temporary players.")) break block5;
                if (this.errorLogged) {
                    return;
                }
                this.plugin.logException(e);
                this.plugin.getLogger().warning("IMPORTANT: Please make sure that you are using the latest dev-build of ProtocolLib and that your server is up-to-date! This error likely happened inside of ProtocolLib code which is out of SuperVanish's control. It's part of an optional invisibility module and can be removed safely by disabling ModifyTablistPackets in the config. Please report this error if you can reproduce it on an up-to-date server with only latest ProtocolLib and latest SV installed.");
                this.errorLogged = true;
            }
        }
    }
}

