/*
 * Decompiled with CFR 0.152.
 */
package de.myzelyam.supervanish.visibility.hiders.modules;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import com.comphenix.protocol.reflect.FieldAccessException;
import com.mojang.brigadier.suggestion.Suggestion;
import com.mojang.brigadier.suggestion.Suggestions;
import de.myzelyam.supervanish.SuperVanish;
import de.myzelyam.supervanish.visibility.hiders.PlayerHider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.bukkit.plugin.Plugin;

public class TabCompleteModule
extends PacketAdapter {
    private final PlayerHider hider;
    private final SuperVanish plugin;
    private boolean errorLogged = false;

    public TabCompleteModule(SuperVanish plugin, PlayerHider hider) {
        super((Plugin)plugin, ListenerPriority.HIGH, new PacketType[]{PacketType.Play.Server.TAB_COMPLETE});
        this.plugin = plugin;
        this.hider = hider;
    }

    public static void register(SuperVanish plugin, PlayerHider hider) {
        ProtocolLibrary.getProtocolManager().addPacketListener((PacketListener)new TabCompleteModule(plugin, hider));
    }

    public void onPacketSending(PacketEvent event) {
        block11: {
            try {
                if (this.plugin.getVersionUtil().isOneDotXOrHigher(13)) {
                    try {
                        Suggestions suggestions = (Suggestions)event.getPacket().getSpecificModifier(Suggestions.class).read(0);
                        Iterator iterator = suggestions.getList().iterator();
                        boolean containsHiddenPlayer = false;
                        while (iterator.hasNext()) {
                            Suggestion suggestion = (Suggestion)iterator.next();
                            String completion = suggestion.getText();
                            if (completion.contains("/") || !this.hider.isHidden(completion, event.getPlayer())) continue;
                            iterator.remove();
                            containsHiddenPlayer = true;
                        }
                        if (containsHiddenPlayer) {
                            event.getPacket().getSpecificModifier(Suggestions.class).write(0, (Object)suggestions);
                        }
                        break block11;
                    }
                    catch (FieldAccessException e) {
                        if (this.errorLogged) {
                            return;
                        }
                        this.plugin.getLogger().warning("Could not intercept tab-completions using ProtocolLib: " + e.getMessage());
                        this.errorLogged = true;
                    }
                    break block11;
                }
                String[] suggestions = (String[])event.getPacket().getStringArrays().read(0);
                boolean containsHiddenPlayer = false;
                ArrayList<String> suggestionList = new ArrayList<String>(Arrays.asList(suggestions));
                for (String suggestion : suggestions) {
                    if (suggestion.contains("/") || !this.hider.isHidden(suggestion, event.getPlayer())) continue;
                    suggestionList.remove(suggestion);
                    containsHiddenPlayer = true;
                }
                if (containsHiddenPlayer) {
                    event.getPacket().getStringArrays().write(0, (Object)suggestionList.toArray(new String[suggestionList.size()]));
                }
            }
            catch (Exception | NoClassDefFoundError e) {
                if (e.getMessage() != null && e.getMessage().endsWith("is not supported for temporary players.")) break block11;
                if (this.errorLogged) {
                    return;
                }
                this.plugin.logException(e);
                this.plugin.getLogger().warning("IMPORTANT: Please make sure that you are using the latest dev-build of ProtocolLib and that your server is up-to-date! This error likely happened inside of ProtocolLib code which is out of SuperVanish's control. It's part of an optional invisibility module and can be removed safely by disabling ModifyTabCompletePackets in the config. Please report this error if you can reproduce it on an up-to-date server with only latest ProtocolLib and latest SV installed.");
                this.errorLogged = true;
            }
        }
    }
}

